/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.FieldChartWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.QuickvaluesWidget;
import org.graylog2.dashboards.widgets.SearchResultChartWidget;
import org.graylog2.dashboards.widgets.SearchResultCountWidget;
import org.graylog2.dashboards.widgets.StatisticalCountWidget;
import org.graylog2.dashboards.widgets.StreamSearchResultCountWidget;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.KeywordRange;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.rest.resources.dashboards.requests.AddWidgetRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class DashboardWidget
implements EmbeddedPersistable {
    private final MetricRegistry metricRegistry;
    private static final String RESULT_CACHE_KEY = "result";
    public static final int DEFAULT_CACHE_TIME = 10;
    private final Type type;
    private final String id;
    private final Map<String, Object> config;
    private final String creatorUserId;
    private int cacheTime;
    private String description;
    private Cache<String, ComputationResult> cache;

    protected DashboardWidget(MetricRegistry metricRegistry, Type type, String id, String description, int cacheTimeS, Map<String, Object> config, String creatorUserId) {
        this.metricRegistry = metricRegistry;
        this.type = type;
        this.id = id;
        this.config = config;
        this.creatorUserId = creatorUserId;
        this.description = description;
        this.cacheTime = cacheTimeS < 1 ? 10 : cacheTimeS;
        this.cache = this.buildCache(this.cacheTime);
    }

    private Cache<String, ComputationResult> buildCache(int cacheTime) {
        return CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite((long)cacheTime, TimeUnit.SECONDS).build();
    }

    public static DashboardWidget fromRequest(MetricRegistry metricRegistry, Searches searches, AddWidgetRequest awr, String userId) throws NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        TimeRange timeRange;
        Type type;
        try {
            type = Type.valueOf(awr.type().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchWidgetTypeException("No such widget type <" + awr.type() + ">");
        }
        String id = UUID.randomUUID().toString();
        if (!awr.config().containsKey("range_type")) {
            throw new InvalidRangeParametersException("range_type not set");
        }
        String rangeType = (String)awr.config().get("range_type");
        if (rangeType.equals("relative")) {
            timeRange = new RelativeRange(Integer.parseInt((String)awr.config().get("range")));
        } else if (rangeType.equals("keyword")) {
            timeRange = new KeywordRange((String)awr.config().get("keyword"));
        } else if (rangeType.equals("absolute")) {
            timeRange = new AbsoluteRange((String)awr.config().get("from"), (String)awr.config().get("to"));
        } else {
            throw new InvalidRangeParametersException("range_type not recognized");
        }
        return DashboardWidget.buildDashboardWidget(type, metricRegistry, searches, id, awr.description(), 0, awr.config(), (String)awr.config().get("query"), timeRange, userId);
    }

    public static DashboardWidget fromPersisted(MetricRegistry metricRegistry, Searches searches, BasicDBObject fields) throws NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        TimeRange timeRange;
        Type type;
        try {
            type = Type.valueOf(((String)fields.get("type")).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchWidgetTypeException();
        }
        BasicDBObject config = (BasicDBObject)fields.get("config");
        BasicDBObject timerangeConfig = (BasicDBObject)config.get("timerange");
        if (!timerangeConfig.containsField("type")) {
            throw new InvalidRangeParametersException("range type not set");
        }
        String rangeType = (String)timerangeConfig.get("type");
        if (rangeType.equals("relative")) {
            timeRange = new RelativeRange((Integer)timerangeConfig.get("range"));
        } else if (rangeType.equals("keyword")) {
            timeRange = new KeywordRange((String)timerangeConfig.get("keyword"));
        } else if (rangeType.equals("absolute")) {
            String from = new DateTime(timerangeConfig.get("from"), DateTimeZone.UTC).toString("yyyy-MM-dd HH:mm:ss.SSS");
            String to = new DateTime(timerangeConfig.get("to"), DateTimeZone.UTC).toString("yyyy-MM-dd HH:mm:ss.SSS");
            timeRange = new AbsoluteRange(from, to);
        } else {
            throw new InvalidRangeParametersException("range_type not recognized");
        }
        String description = null;
        if (fields.containsField("description")) {
            description = (String)fields.get("description");
        }
        int cacheTime = 0;
        if (fields.containsField("cache_time")) {
            cacheTime = (Integer)fields.get("cache_time");
        }
        return DashboardWidget.buildDashboardWidget(type, metricRegistry, searches, (String)fields.get("id"), description, cacheTime, (Map<String, Object>)config, (String)config.get("query"), timeRange, (String)fields.get("creator_user_id"));
    }

    public static DashboardWidget buildDashboardWidget(Type type, MetricRegistry metricRegistry, Searches searches, String widgetId, String description, int cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) throws NoSuchWidgetTypeException, InvalidWidgetConfigurationException {
        switch (type) {
            case SEARCH_RESULT_COUNT: {
                return new SearchResultCountWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case STREAM_SEARCH_RESULT_COUNT: {
                return new StreamSearchResultCountWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case FIELD_CHART: {
                return new FieldChartWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case QUICKVALUES: {
                return new QuickvaluesWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case SEARCH_RESULT_CHART: {
                return new SearchResultChartWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
            case STATS_COUNT: {
                return new StatisticalCountWidget(metricRegistry, searches, widgetId, description, cacheTime, config, query, timeRange, creatorUserId);
            }
        }
        throw new NoSuchWidgetTypeException();
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCacheTime(int cacheTime) {
        this.cache = this.buildCache(cacheTime);
        this.cacheTime = cacheTime;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)"id", (Object)this.id).put((Object)"type", (Object)this.type.toString().toLowerCase()).put((Object)"description", (Object)this.description).put((Object)"cache_time", (Object)this.cacheTime).put((Object)"creator_user_id", (Object)this.creatorUserId).put((Object)"config", this.getPersistedConfig()).build();
    }

    public ComputationResult getComputationResult() throws ExecutionException {
        return (ComputationResult)this.cache.get((Object)RESULT_CACHE_KEY, (Callable)new Callable<ComputationResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComputationResult call() throws Exception {
                ComputationResult result;
                Timer.Context timer = DashboardWidget.this.getCalculationTimer().time();
                try {
                    result = DashboardWidget.this.compute();
                }
                finally {
                    timer.stop();
                }
                DashboardWidget.this.getCalculationMeter().mark();
                return result;
            }
        });
    }

    public abstract Map<String, Object> getPersistedConfig();

    protected abstract ComputationResult compute();

    private Timer getCalculationTimer() {
        return this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{this.getId(), "calculationTime"}));
    }

    private Meter getCalculationMeter() {
        return this.metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{this.getId(), "calculations"}));
    }

    public static class NoSuchWidgetTypeException
    extends Exception {
        public NoSuchWidgetTypeException() {
        }

        public NoSuchWidgetTypeException(String msg) {
            super(msg);
        }
    }

    public static enum Type {
        SEARCH_RESULT_COUNT,
        STREAM_SEARCH_RESULT_COUNT,
        FIELD_CHART,
        QUICKVALUES,
        SEARCH_RESULT_CHART,
        STATS_COUNT;

    }
}

