/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldChartWidget
extends DashboardWidget {
    private static final Logger LOG = LoggerFactory.getLogger(FieldChartWidget.class);
    private final String query;
    private final TimeRange timeRange;
    @Nullable
    private final String streamId;
    private final Map<String, Object> config;
    private final Searches searches;

    public FieldChartWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, int cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) throws InvalidWidgetConfigurationException {
        super(metricRegistry, DashboardWidget.Type.FIELD_CHART, id, description, cacheTime, config, creatorUserId);
        this.searches = searches;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        this.query = query == null || query.trim().isEmpty() ? "*" : query;
        this.timeRange = timeRange;
        this.config = config;
        this.streamId = (String)config.get("stream_id");
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder().put((Object)"query", (Object)this.query).put((Object)"timerange", this.timeRange.getPersistedConfig()).put((Object)"field", this.config.get("field")).put((Object)"valuetype", this.config.get("valuetype")).put((Object)"renderer", this.config.get("renderer")).put((Object)"interpolation", this.config.get("interpolation")).put((Object)"interval", this.config.get("interval"));
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        try {
            HistogramResult histogramResult = this.searches.fieldHistogram(this.query, (String)this.config.get("field"), Searches.DateHistogramInterval.valueOf(((String)this.config.get("interval")).toUpperCase()), filter, this.timeRange);
            return new ComputationResult(histogramResult.getResults(), histogramResult.took().millis(), histogramResult.getHistogramBoundaries());
        }
        catch (Searches.FieldTypeException e) {
            String msg = "Could not calculate [" + this.getClass().getCanonicalName() + "] widget <" + this.getId() + ">. Not a numeric field? The field was [" + this.config.get("field") + "]";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("field") && config.containsKey("valuetype") && config.containsKey("renderer") && config.containsKey("interpolation") && config.containsKey("interval");
    }
}

