/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.SearchResultCountWidget;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

public class StatisticalCountWidget
extends SearchResultCountWidget {
    private final String statsFunction;
    private final String field;
    private final String streamId;

    public StatisticalCountWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, int cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        super(metricRegistry, DashboardWidget.Type.STATS_COUNT, searches, id, description, cacheTime, config, query, timeRange, creatorUserId);
        this.field = (String)config.get("field");
        this.statsFunction = (String)config.get("stats_function");
        this.streamId = (String)config.get("stream_id");
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        Map<String, Object> inheritedConfig = super.getPersistedConfig();
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder();
        persistedConfig.putAll(inheritedConfig);
        persistedConfig.put((Object)"field", (Object)this.field);
        persistedConfig.put((Object)"stats_function", (Object)this.statsFunction);
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }

    private Number getStatisticalValue(FieldStatsResult fieldStatsResult) {
        Number statisticalValue;
        switch (this.statsFunction) {
            case "count": {
                statisticalValue = fieldStatsResult.getCount();
                break;
            }
            case "mean": {
                statisticalValue = fieldStatsResult.getMean();
                break;
            }
            case "stddev": {
                statisticalValue = fieldStatsResult.getStdDeviation();
                break;
            }
            case "min": {
                statisticalValue = fieldStatsResult.getMin();
                break;
            }
            case "max": {
                statisticalValue = fieldStatsResult.getMax();
                break;
            }
            case "sum": {
                statisticalValue = fieldStatsResult.getSum();
                break;
            }
            case "variance": {
                statisticalValue = fieldStatsResult.getVariance();
                break;
            }
            case "squares": {
                statisticalValue = fieldStatsResult.getSumOfSquares();
                break;
            }
            default: {
                throw new IllegalArgumentException("Statistic function " + this.statsFunction + " is not supported");
            }
        }
        return statisticalValue;
    }

    @Override
    protected ComputationResult compute() {
        try {
            String filter = !Strings.isNullOrEmpty((String)this.streamId) ? "streams:" + this.streamId : null;
            FieldStatsResult fieldStatsResult = this.getSearches().fieldStats(this.field, this.query, filter, this.timeRange);
            if (this.trend.booleanValue() && this.timeRange instanceof RelativeRange) {
                DateTime toPrevious = this.timeRange.getFrom();
                DateTime fromPrevious = toPrevious.minus((ReadablePeriod)Seconds.seconds((int)((RelativeRange)this.timeRange).getRange()));
                AbsoluteRange previousTimeRange = new AbsoluteRange(fromPrevious, toPrevious);
                FieldStatsResult previousFieldStatsResult = this.getSearches().fieldStats(this.field, this.query, filter, previousTimeRange);
                HashMap results = Maps.newHashMap();
                results.put("now", this.getStatisticalValue(fieldStatsResult));
                results.put("previous", this.getStatisticalValue(previousFieldStatsResult));
                long tookMs = fieldStatsResult.took().millis() + previousFieldStatsResult.took().millis();
                return new ComputationResult(results, tookMs);
            }
            return new ComputationResult(this.getStatisticalValue(fieldStatsResult), fieldStatsResult.took().millis());
        }
        catch (Searches.FieldTypeException e) {
            throw new RuntimeException("Invalid field provided.", e);
        }
    }
}

