/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.dashboards.widgets.ComputationResult;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.SearchResultCountWidget;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.TimeRange;

public class StreamSearchResultCountWidget
extends SearchResultCountWidget {
    private final String streamId;

    public StreamSearchResultCountWidget(MetricRegistry metricRegistry, Searches searches, String id, String description, int cacheTime, Map<String, Object> config, String query, TimeRange timeRange, String creatorUserId) {
        super(metricRegistry, DashboardWidget.Type.STREAM_SEARCH_RESULT_COUNT, searches, id, description, cacheTime, config, query, timeRange, creatorUserId);
        this.streamId = (String)config.get("stream_id");
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        Map<String, Object> inheritedConfig = super.getPersistedConfig();
        ImmutableMap.Builder persistedConfig = ImmutableMap.builder();
        persistedConfig.putAll(inheritedConfig);
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            persistedConfig.put((Object)"stream_id", (Object)this.streamId);
        }
        return persistedConfig.build();
    }

    @Override
    protected ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        return this.computeInternal(filter);
    }
}

