/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.configuration.MongoDbConfiguration;

@Singleton
public class MongoConnection {
    private MongoClient m;
    private DB db;
    private DBCollection messageCountsCollection;
    private String username;
    private List<ServerAddress> replicaServers;
    private int threadsAllowedToBlockMultiplier;
    private boolean useAuth;
    private int maxConnections;
    private String database;
    private String password;
    private String host;
    private int port;

    @Inject
    public MongoConnection(MongoDbConfiguration configuration) {
        this(configuration.getDatabase(), configuration.getHost(), configuration.getPort(), configuration.getReplicaSet(), configuration.isUseAuth(), configuration.getUser(), configuration.getPassword(), configuration.getMaxConnections(), configuration.getThreadsAllowedToBlockMultiplier());
    }

    public MongoConnection(String database, String host, int port, List<ServerAddress> replicaServers, boolean useAuth, String username, String password, int maxConnections, int threadsAllowedToBlockMultiplier) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.replicaServers = replicaServers;
        this.useAuth = useAuth;
        this.username = username;
        this.password = password;
        this.maxConnections = maxConnections;
        this.threadsAllowedToBlockMultiplier = threadsAllowedToBlockMultiplier;
    }

    public synchronized MongoClient connect() {
        if (this.m == null) {
            MongoClientOptions.Builder options = new MongoClientOptions.Builder();
            options.connectionsPerHost(this.maxConnections);
            options.threadsAllowedToBlockForConnectionMultiplier(this.threadsAllowedToBlockMultiplier);
            try {
                if (this.replicaServers != null && this.replicaServers.size() > 0) {
                    this.m = new MongoClient(this.replicaServers, options.build());
                } else {
                    ServerAddress address = new ServerAddress(this.host, this.port);
                    this.m = new MongoClient(address, options.build());
                }
                this.db = this.m.getDB(this.database);
                this.db.setWriteConcern(WriteConcern.SAFE);
                if (this.useAuth && !this.db.authenticate(this.username, this.password.toCharArray())) {
                    throw new RuntimeException("Could not authenticate to database '" + this.database + "' with user '" + this.username + "'.");
                }
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot resolve host name for MongoDB", e);
            }
        }
        return this.m;
    }

    public DB getDatabase() {
        return this.db;
    }

    public DBCollection getMessageCountsColl() {
        if (this.messageCountsCollection != null) {
            return this.messageCountsCollection;
        }
        DBCollection coll = this.getDatabase().getCollection("message_counts");
        coll.createIndex((DBObject)new BasicDBObject("timestamp", (Object)1));
        this.messageCountsCollection = coll;
        return coll;
    }

    public void setUser(String mongoUser) {
        this.username = mongoUser;
    }

    public void setReplicaSet(List<ServerAddress> mongoReplicaSet) {
        this.replicaServers = mongoReplicaSet;
    }

    public void setThreadsAllowedToBlockMultiplier(int mongoThreadsAllowedToBlockMultiplier) {
        this.threadsAllowedToBlockMultiplier = mongoThreadsAllowedToBlockMultiplier;
    }

    public void setUseAuth(boolean mongoUseAuth) {
        this.useAuth = mongoUseAuth;
    }

    public void setMaxConnections(int mongoMaxConnections) {
        this.maxConnections = mongoMaxConnections;
    }

    public void setDatabase(String mongoDatabase) {
        this.database = mongoDatabase;
    }

    public void setPassword(String mongoPassword) {
        this.password = mongoPassword;
    }

    public void setHost(String mongoHost) {
        this.host = mongoHost;
    }

    public void setPort(int mongoPort) {
        this.port = mongoPort;
    }
}

