/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.healing;

import com.google.inject.assistedinject.AssistedInject;
import org.graylog2.buffers.Buffers;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixDeflectorByMoveJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(FixDeflectorByMoveJob.class);
    public static final int MAX_CONCURRENCY = 1;
    private final Deflector deflector;
    private final ServerStatus serverStatus;
    private final Indices indices;
    private final ActivityWriter activityWriter;
    private final Buffers bufferSynchronizer;
    private final NotificationService notificationService;
    private boolean cancelRequested = false;
    private int progress = 0;

    @AssistedInject
    public FixDeflectorByMoveJob(Deflector deflector, Indices indices, ServerStatus serverStatus, ActivityWriter activityWriter, Buffers bufferSynchronizer, NotificationService notificationService) {
        super(serverStatus);
        this.deflector = deflector;
        this.indices = indices;
        this.serverStatus = serverStatus;
        this.activityWriter = activityWriter;
        this.bufferSynchronizer = bufferSynchronizer;
        this.notificationService = notificationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.deflector.isUp() || !this.indices.exists(this.deflector.getName())) {
            LOG.error("There is no index <{}>. No need to run this job. Aborting.", (Object)this.deflector.getName());
            return;
        }
        LOG.info("Attempting to fix deflector with move strategy.");
        boolean wasProcessing = true;
        try {
            wasProcessing = this.serverStatus.isProcessing();
            this.serverStatus.pauseMessageProcessing();
            this.progress = 5;
            this.bufferSynchronizer.waitForEmptyBuffers();
            this.progress = 10;
            String newTarget = null;
            try {
                newTarget = this.deflector.getNewestTargetName();
                LOG.info("Starting to move <{}> to <{}>.", (Object)this.deflector.getName(), (Object)newTarget);
                this.indices.move(this.deflector.getName(), newTarget);
            }
            catch (Exception e) {
                LOG.error("Moving index failed. Rolling back.", (Throwable)e);
                if (newTarget != null) {
                    this.indices.delete(newTarget);
                }
                throw new RuntimeException(e);
            }
            LOG.info("Done moving deflector index.");
            this.progress = 85;
            LOG.info("Deleting <{}> index.", (Object)this.deflector.getName());
            this.indices.delete(this.deflector.getName());
            this.progress = 90;
            this.deflector.setUp();
            this.progress = 95;
        }
        finally {
            try {
                this.serverStatus.unlockProcessingPause();
                if (wasProcessing) {
                    this.serverStatus.resumeMessageProcessing();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not unlock processing pause.", e);
            }
        }
        this.progress = 90;
        this.activityWriter.write(new Activity("Notification condition [" + (Object)((Object)Notification.Type.DEFLECTOR_EXISTS_AS_INDEX) + "] " + "has been fixed.", this.getClass()));
        this.notificationService.fixed(Notification.Type.DEFLECTOR_EXISTS_AS_INDEX);
        this.progress = 100;
        LOG.info("Finished.");
    }

    @Override
    public void requestCancel() {
        this.cancelRequested = true;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int maxConcurrency() {
        return 1;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Tries to fix a broken deflector alias by converting the deflector index to a valid index. Triggered by hand after a notification. This operation can take some time depending on the number of messages that were already written into the deflector index.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public FixDeflectorByMoveJob create();
    }
}

