/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.highlight.HighlightField;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ResultMessage.class);
    private Map<String, Object> message;
    private String index;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Multimap<String, Range<Integer>> highlightRanges;

    protected ResultMessage() {
    }

    public static ResultMessage parseFromSource(SearchHit hit) {
        ResultMessage m = new ResultMessage();
        if (hit.getSource() != null) {
            m.setMessage(hit.getSource());
        } else {
            HashMap map = Maps.newHashMap();
            for (Map.Entry o : hit.fields().entrySet()) {
                map.put(o.getKey(), ((SearchHitField)o.getValue()).getValue());
            }
            m.setMessage(map);
        }
        m.setIndex(hit.getIndex());
        m.setHighlightRanges(hit.getHighlightFields());
        return m;
    }

    public static ResultMessage parseFromSource(GetResponse r) {
        ResultMessage m = new ResultMessage();
        m.setMessage(r.getSource());
        m.setIndex(r.getIndex());
        return m;
    }

    public void setMessage(Map<String, Object> message) {
        this.message = message;
        if (this.message.containsKey("timestamp")) {
            Object tsField = this.message.get("timestamp");
            try {
                this.message.put("timestamp", Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(tsField)));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not parse timestamp of message {}", message.get("id"), (Object)e);
            }
        }
    }

    public void setHighlightRanges(Map<String, HighlightField> highlightFields) {
        if (!highlightFields.isEmpty()) {
            this.highlightRanges = ArrayListMultimap.create();
            for (Map.Entry<String, HighlightField> hlEntry : highlightFields.entrySet()) {
                int startIdx;
                HighlightField highlight = hlEntry.getValue();
                String s = highlight.fragments()[0].toString();
                int pos = 0;
                int cutChars = 0;
                while ((startIdx = s.indexOf("<em>", pos)) != -1) {
                    int endIdx = s.indexOf("</em>", startIdx);
                    Range highlightPosition = Range.closedOpen((Comparable)Integer.valueOf(startIdx - cutChars), (Comparable)Integer.valueOf(endIdx - cutChars - 4));
                    pos = endIdx;
                    cutChars += 9;
                    this.highlightRanges.put((Object)hlEntry.getKey(), (Object)highlightPosition);
                }
            }
            LOG.debug("Highlight positions for message {}: {}", this.message.get("_id"), this.highlightRanges);
        }
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Map<String, Object> getMessage() {
        return this.message;
    }

    public String getIndex() {
        return this.index;
    }
}

