/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsResult
extends IndexQueryResult {
    private final long total;
    private final long missing;
    private final long other;
    private final Map<String, Integer> terms;

    public TermsResult(TermsFacet f, String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.total = f.getTotalCount();
        this.missing = f.getMissingCount();
        this.other = f.getOtherCount();
        this.terms = this.buildTermsMap(f.getEntries());
    }

    private Map<String, Integer> buildTermsMap(List<? extends TermsFacet.Entry> entries) {
        HashMap terms = Maps.newHashMap();
        for (TermsFacet.Entry entry : entries) {
            terms.put(entry.getTerm().string(), entry.getCount());
        }
        return terms;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMissing() {
        return this.missing;
    }

    public long getOther() {
        return this.other;
    }

    public Map<String, Integer> getTerms() {
        return this.terms;
    }
}

