/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches.timeranges;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.utilities.date.NaturalDateParser;
import org.joda.time.DateTime;

public class KeywordRange
implements TimeRange {
    private final String keyword;
    private final DateTime from;
    private final DateTime to;

    @Override
    public TimeRange.Type getType() {
        return TimeRange.Type.KEYWORD;
    }

    public KeywordRange(String keyword) throws InvalidRangeParametersException {
        if (keyword == null || keyword.isEmpty()) {
            throw new InvalidRangeParametersException();
        }
        try {
            NaturalDateParser.Result result = new NaturalDateParser().parse(keyword);
            this.from = result.getFrom();
            this.to = result.getTo();
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            throw new InvalidRangeParametersException("Could not parse from natural date: " + keyword);
        }
        this.keyword = keyword;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.builder().put((Object)"type", (Object)this.getType().toString().toLowerCase()).put((Object)"keyword", (Object)this.getKeyword()).build();
    }

    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public DateTime getFrom() {
        return this.from;
    }

    @Override
    public DateTime getTo() {
        return this.to;
    }
}

