/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.outputs.ElasticSearchOutput;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedElasticSearchOutput
extends ElasticSearchOutput {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedElasticSearchOutput.class);
    private final List<Message> buffer;
    private final int maxBufferSize;
    private final ExecutorService flushThread;
    private final Timer processTime;
    private final Histogram batchSize;
    private final Meter bufferFlushes;
    private final Meter bufferFlushesRequested;
    private final Cluster cluster;

    @AssistedInject
    public BatchedElasticSearchOutput(MetricRegistry metricRegistry, Messages messages, Cluster cluster, Configuration serverConfiguration, Journal journal, @Assisted Stream stream, @Assisted org.graylog2.plugin.configuration.Configuration configuration) {
        this(metricRegistry, messages, cluster, serverConfiguration, journal);
    }

    @Inject
    public BatchedElasticSearchOutput(MetricRegistry metricRegistry, Messages messages, Cluster cluster, Configuration serverConfiguration, Journal journal) {
        super(metricRegistry, messages, journal);
        this.cluster = cluster;
        this.maxBufferSize = serverConfiguration.getOutputBatchSize();
        this.buffer = Lists.newArrayListWithCapacity((int)this.maxBufferSize);
        this.processTime = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"processTime"}));
        this.batchSize = metricRegistry.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"batchSize"}));
        this.bufferFlushes = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushes"}));
        this.bufferFlushesRequested = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushesRequested"}));
        this.flushThread = this.executorService(metricRegistry);
    }

    private ExecutorService executorService(MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("batched-elasticsearch-output-%d").build();
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(threadFactory), metricRegistry, MetricRegistry.name(this.getClass(), (String[])new String[]{"executor-service"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Message message) throws Exception {
        List<Message> list = this.buffer;
        synchronized (list) {
            this.buffer.add(message);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Buffering message id to [{}]: <{}>", this.getClass(), (Object)message.getId());
            }
            if (this.buffer.size() >= this.maxBufferSize) {
                this.flush();
            }
        }
    }

    private void synchronousFlush(List<Message> messageBuffer) {
        LOG.debug("[{}] Starting flushing {} messages", (Object)Thread.currentThread(), (Object)messageBuffer.size());
        try (Timer.Context context = this.processTime.time();){
            this.write(messageBuffer);
            this.batchSize.update(messageBuffer.size());
            this.bufferFlushes.mark();
        }
        catch (Exception e) {
            LOG.error("Unable to flush message buffer", (Throwable)e);
        }
        LOG.debug("[{}] Flushing {} messages completed", (Object)Thread.currentThread(), (Object)messageBuffer.size());
    }

    private void asynchronousFlush(final List<Message> mybuffer) {
        LOG.debug("Submitting new flush thread");
        this.flushThread.submit(new Runnable(){

            @Override
            public void run() {
                BatchedElasticSearchOutput.this.synchronousFlush(mybuffer);
            }
        });
    }

    public void flush() {
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void flush(boolean async) {
        this.bufferFlushesRequested.mark();
        if (!this.buffer.isEmpty()) {
            if (this.cluster.isConnectedAndHealthy()) {
                ImmutableList temporaryBuffer;
                List<Message> list = this.buffer;
                synchronized (list) {
                    temporaryBuffer = ImmutableList.copyOf(this.buffer);
                    this.buffer.clear();
                }
                if (async) {
                    this.asynchronousFlush((List<Message>)temporaryBuffer);
                } else {
                    this.synchronousFlush((List<Message>)temporaryBuffer);
                }
            } else {
                LOG.warn("Clearing buffer ({} messages) because the Elasticsearch cluster is down.", (Object)this.buffer.size());
                this.buffer.clear();
            }
        } else {
            LOG.debug("Not flushing empty buffer");
        }
    }

    public static class Descriptor
    extends ElasticSearchOutput.Descriptor {
        public Descriptor() {
            super("Batched Elasticsearch Output", false, "", "Elasticsearch Output with Batching");
        }
    }

    public static class Config
    extends ElasticSearchOutput.Config {
    }

    public static interface Factory
    extends ElasticSearchOutput.Factory {
        @Override
        public BatchedElasticSearchOutput create(Stream var1, org.graylog2.plugin.configuration.Configuration var2);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

