/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.GelfMessageBuilder;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfOutput
implements MessageOutput {
    private static final Logger LOG = LoggerFactory.getLogger(GelfOutput.class);
    private static final String CK_PROTOCOL = "protocol";
    private static final String CK_HOSTNAME = "hostname";
    private static final String CK_PORT = "port";
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Configuration configuration;
    private final GelfTransport transport;

    @Inject
    public GelfOutput(@Assisted Stream stream, @Assisted Configuration configuration) throws MessageOutputConfigurationException {
        this.configuration = configuration;
        this.transport = this.buildTransport(configuration);
        this.isRunning.set(true);
    }

    public GelfOutput(Configuration configuration, GelfTransport gelfTransport) {
        this.configuration = configuration;
        this.transport = gelfTransport;
        this.isRunning.set(true);
    }

    public void stop() {
        LOG.debug("Stopping {}", (Object)this.transport.getClass().getName());
        try {
            this.transport.stop();
        }
        catch (Exception e) {
            LOG.error("Error stopping " + this.transport.getClass().getName(), (Throwable)e);
        }
        this.isRunning.set(false);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    protected GelfTransport buildTransport(Configuration configuration) throws MessageOutputConfigurationException {
        GelfTransport gelfTransport;
        String protocol = configuration.getString(CK_PROTOCOL);
        String hostname = configuration.getString(CK_HOSTNAME);
        if (Strings.isNullOrEmpty((String)protocol) || Strings.isNullOrEmpty((String)hostname) || !configuration.intIsSet(CK_PORT)) {
            throw new MessageOutputConfigurationException("Protocol and/or hostname missing!");
        }
        int port = configuration.getInt(CK_PORT);
        GelfConfiguration gelfConfiguration = new GelfConfiguration(hostname, port).transport(GelfTransports.valueOf((String)protocol.toUpperCase()));
        LOG.debug("Initializing GELF sender and connecting to {}://{}:{}", new Object[]{protocol, hostname, port});
        try {
            gelfTransport = GelfTransports.create((GelfConfiguration)gelfConfiguration);
        }
        catch (Exception e) {
            String error = "Error initializing " + this.getClass() + ": " + e.getMessage();
            LOG.error(error, (Throwable)e);
            throw new MessageOutputConfigurationException(error);
        }
        return gelfTransport;
    }

    public void write(Message message) throws Exception {
        this.transport.send(this.toGELFMessage(message));
    }

    public void write(List<Message> messages) throws Exception {
        for (Message message : messages) {
            this.write(message);
        }
    }

    private GelfMessageLevel extractLevel(Object rawLevel) {
        if (rawLevel != null && rawLevel instanceof Number) {
            return GelfMessageLevel.fromNumericLevel((int)((Number)rawLevel).intValue());
        }
        if (rawLevel instanceof String) {
            try {
                return GelfMessageLevel.fromNumericLevel((int)Integer.getInteger(rawLevel.toString()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected GelfMessage toGELFMessage(Message message) {
        DateTime timestamp = message.getField("timestamp") != null || message.getField("timestamp") instanceof DateTime ? (DateTime)message.getField("timestamp") : Tools.iso8601();
        GelfMessageLevel messageLevel = this.extractLevel(message.getField("level"));
        String fullMessage = (String)message.getField("message");
        String facility = (String)message.getField("facility");
        String forwarder = GelfOutput.class.getCanonicalName();
        GelfMessageBuilder builder = new GelfMessageBuilder(message.getMessage(), message.getSource()).timestamp((double)timestamp.getMillis() / 1000.0).additionalField("_forwarder", (Object)forwarder).additionalFields(message.getFields());
        if (messageLevel != null) {
            builder.level(messageLevel);
        }
        if (fullMessage != null) {
            builder.fullMessage(fullMessage);
        }
        if (facility != null) {
            builder.additionalField("_facility", (Object)facility);
        }
        return builder.build();
    }

    public static class Descriptor
    extends MessageOutput.Descriptor {
        public Descriptor() {
            super("GELF Output", false, "", "An output sending GELF over TCP or UDP");
        }
    }

    public static class Config
    extends MessageOutput.Config {
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configurationRequest = new ConfigurationRequest();
            configurationRequest.addField((ConfigurationField)new TextField(GelfOutput.CK_HOSTNAME, "Destination host", "", "This is the hostname of the destination", ConfigurationField.Optional.NOT_OPTIONAL));
            configurationRequest.addField((ConfigurationField)new NumberField(GelfOutput.CK_PORT, "Destination port", 12201, "This is the port of the destination", ConfigurationField.Optional.NOT_OPTIONAL));
            ImmutableMap protocols = ImmutableMap.of((Object)"TCP", (Object)"TCP", (Object)"UDP", (Object)"UDP");
            configurationRequest.addField((ConfigurationField)new DropdownField(GelfOutput.CK_PROTOCOL, "Protocol", "TCP", (Map)protocols, "The protocol used to connect", ConfigurationField.Optional.OPTIONAL));
            return configurationRequest;
        }
    }

    public static interface Factory
    extends MessageOutput.Factory<GelfOutput> {
        public GelfOutput create(Stream var1, Configuration var2);

        public Config getConfig();

        public Descriptor getDescriptor();
    }
}

