/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import com.mongodb.MongoException;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.graylog2.bundles.BundleService;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.plugin.periodical.Periodical;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackLoaderPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ContentPackLoaderPeriodical.class);
    private static final String RESOURCE_PREFIX = "contentpacks";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile(".*\\.json");
    private final ObjectMapper objectMapper;
    private final BundleService bundleService;

    @Inject
    public ContentPackLoaderPeriodical(ObjectMapper objectMapper, BundleService bundleService) {
        this.objectMapper = objectMapper;
        this.bundleService = bundleService;
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void doRun() {
        Set resources = new Reflections(RESOURCE_PREFIX, new Scanner[]{new ResourcesScanner()}).getResources(RESOURCE_PATTERN);
        for (String resource : resources) {
            ConfigurationBundle contentPack;
            byte[] resourceBytes;
            URL resourceUrl = Resources.getResource((String)resource);
            try {
                resourceBytes = Resources.toByteArray((URL)resourceUrl);
            }
            catch (IOException e) {
                LOG.warn("Couldn't read " + resource + ". Skipping.", (Throwable)e);
                continue;
            }
            try {
                contentPack = (ConfigurationBundle)this.objectMapper.readValue(resourceBytes, ConfigurationBundle.class);
            }
            catch (IOException e) {
                LOG.warn("Couldn't parse content pack " + resource + ". Skipping", (Throwable)e);
                continue;
            }
            if (this.bundleService.findByNameAndCategory(contentPack.getName(), contentPack.getCategory()) != null) {
                LOG.debug("Content pack {}/{} already exists in database. Skipping.", (Object)contentPack.getCategory(), (Object)contentPack.getName());
                continue;
            }
            try {
                ConfigurationBundle insertedContentPack = this.bundleService.insert(contentPack);
                LOG.debug("Successfully inserted content pack {} into database with ID {}", (Object)resource, (Object)insertedContentPack.getId());
            }
            catch (MongoException e) {
                LOG.error("Error while inserting content pack " + resource + " into database. Skipping.", (Throwable)e);
            }
        }
    }
}

