/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.indexer.IndexFailureImpl;
import org.graylog2.indexer.IndexFailureService;
import org.graylog2.indexer.PersistedDeadLetterImpl;
import org.graylog2.indexer.PersistedDeadLetterService;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLetterThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(DeadLetterThread.class);
    private final PersistedDeadLetterService persistedDeadLetterService;
    private final IndexFailureService indexFailureService;
    private final Messages messages;
    private final Configuration configuration;
    private final MongoConnection mongoConnection;
    private final MetricRegistry metricRegistry;

    @Inject
    public DeadLetterThread(PersistedDeadLetterService persistedDeadLetterService, IndexFailureService indexFailureService, Messages messages, Configuration configuration, MongoConnection mongoConnection, MetricRegistry metricRegistry) {
        this.persistedDeadLetterService = persistedDeadLetterService;
        this.indexFailureService = indexFailureService;
        this.messages = messages;
        this.configuration = configuration;
        this.mongoConnection = mongoConnection;
        this.metricRegistry = metricRegistry;
    }

    /*
     * Unable to fully structure code
     */
    public void doRun() {
        this.verifyIndices();
        block6: while (true) {
            try {
                items = this.messages.getDeadLetterQueue().take();
            }
            catch (InterruptedException ignored) {
                continue;
            }
            i$ = items.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block6;
                item = i$.next();
                written = false;
                if (this.configuration.isDeadLettersEnabled()) {
                    try {
                        message = item.getMessage();
                        doc = Maps.newHashMap();
                        doc.put("letter_id", item.getId());
                        doc.put("timestamp", Tools.iso8601());
                        doc.put("message", message.toElasticSearchObject());
                        persistedDeadLetter = new PersistedDeadLetterImpl(doc);
                        this.persistedDeadLetterService.saveWithoutValidation(persistedDeadLetter);
                        written = true;
                    }
                    catch (Exception e) {
                        DeadLetterThread.LOG.error("Could not write message to dead letter queue.", (Throwable)e);
                    }
                }
                try {
                    f = item.getFailure().getFailure();
                    doc = Maps.newHashMap();
                    doc.put("letter_id", item.getId());
                    doc.put("index", f.getIndex());
                    doc.put("type", f.getType());
                    doc.put("message", f.getMessage());
                    doc.put("timestamp", item.getTimestamp());
                    doc.put("written", written);
                    indexFailure = new IndexFailureImpl(doc);
                    this.indexFailureService.saveWithoutValidation(indexFailure);
                    continue;
                }
                catch (Exception e) {
                    DeadLetterThread.LOG.error("Could not persist index failure.", (Throwable)e);
                    continue;
                }
                break;
            }
            break;
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    private void verifyIndices() {
        this.mongoConnection.getDatabase().getCollection(this.getCollectionName(IndexFailureImpl.class)).createIndex((DBObject)new BasicDBObject("timestamp", (Object)1));
        this.mongoConnection.getDatabase().getCollection(this.getCollectionName(IndexFailureImpl.class)).createIndex((DBObject)new BasicDBObject("letter_id", (Object)1));
        this.mongoConnection.getDatabase().getCollection(this.getCollectionName(PersistedDeadLetterImpl.class)).createIndex((DBObject)new BasicDBObject("timestamp", (Object)1));
        this.mongoConnection.getDatabase().getCollection(this.getCollectionName(PersistedDeadLetterImpl.class)).createIndex((DBObject)new BasicDBObject("letter_id", (Object)1));
    }

    private String getCollectionName(Class<? extends Persisted> modelClass) {
        return modelClass.getAnnotation(CollectionName.class).value();
    }

    public boolean runsForever() {
        return true;
    }

    public boolean stopOnGracefulShutdown() {
        return false;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean startOnThisNode() {
        return true;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return 0;
    }

    public void initialize() {
        this.metricRegistry.register(MetricRegistry.name(DeadLetterThread.class, (String[])new String[]{"queueSize"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return DeadLetterThread.this.messages.getDeadLetterQueue().size();
            }
        });
    }
}

