/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.alerts;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.alerts.AlertService;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.resources.streams.alerts.requests.CreateConditionRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="AlertConditions", description="Manage stream alert conditions")
@Path(value="/streams/{streamId}/alerts/conditions")
public class StreamAlertConditionResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAlertConditionResource.class);
    private final StreamService streamService;
    private final AlertService alertService;

    @Inject
    public StreamAlertConditionResource(StreamService streamService, AlertService alertService) {
        this.streamService = streamService;
        this.alertService = alertService;
    }

    @POST
    @Timed
    @ApiOperation(value="Create an alert condition")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Response create(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateConditionRequest ccr) throws NotFoundException, ValidationException {
        AlertCondition alertCondition;
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        try {
            alertCondition = this.alertService.fromRequest(ccr, stream, this.getCurrentUser().getName());
        }
        catch (AbstractAlertCondition.NoSuchAlertConditionTypeException e) {
            LOG.error("Invalid alarm condition type.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        this.streamService.addAlertCondition(stream, alertCondition);
        ImmutableMap result = ImmutableMap.of((Object)"alert_condition_id", (Object)alertCondition.getId());
        URI alertConditionUri = UriBuilder.fromResource(StreamAlertConditionResource.class).path("{conditionId}").build(new Object[]{stream.getId(), alertCondition.getId()});
        return Response.created((URI)alertConditionUri).entity((Object)result).build();
    }

    @PUT
    @Timed
    @Path(value="{conditionId}")
    @ApiOperation(value="Modify an alert condition")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public void update(@ApiParam(name="streamId", value="The stream id the alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="conditionId", value="The alert condition id.", required=true) @PathParam(value="conditionId") String conditionid, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateConditionRequest ccr) throws NotFoundException, ValidationException {
        AlertCondition updatedCondition;
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        AlertCondition alertCondition = this.streamService.getAlertCondition(stream, conditionid);
        try {
            updatedCondition = this.alertService.updateFromRequest(alertCondition, ccr);
        }
        catch (AbstractAlertCondition.NoSuchAlertConditionTypeException e) {
            LOG.error("Invalid alarm condition type.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        this.streamService.updateAlertCondition(stream, updatedCondition);
    }

    @GET
    @Timed
    @ApiOperation(value="Get all alert conditions of this stream")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Map<String, Object> list(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        ArrayList conditions = Lists.newArrayList();
        for (AlertCondition alertCondition : this.streamService.getAlertConditions(stream)) {
            conditions.add(this.alertService.asMap(alertCondition));
        }
        return ImmutableMap.of((Object)"conditions", (Object)conditions, (Object)"total", (Object)conditions.size());
    }

    @DELETE
    @Timed
    @Path(value="{conditionId}")
    @ApiOperation(value="Delete an alert condition")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public void delete(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="conditionId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="conditionId") String conditionId) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        this.streamService.removeAlertCondition(stream, conditionId);
    }
}

