/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.database.MongoConnection;
import org.graylog2.metrics.MetricUtils;
import org.graylog2.rest.resources.system.requests.MetricsReadRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Metrics", description="Internal Graylog metrics")
@Path(value="/system/metrics")
public class MetricsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsResource.class);
    private final MetricRegistry metricRegistry;
    private final MongoConnection mongoConnection;

    @Inject
    public MetricsResource(MetricRegistry metricRegistry, MongoConnection mongoConnection) {
        this.metricRegistry = metricRegistry;
        this.mongoConnection = mongoConnection;
    }

    @GET
    @Timed
    @RequiresPermissions(value={"metrics:readall"})
    @ApiOperation(value="Get all metrics", notes="Note that this might return a huge result set.")
    @Produces(value={"application/json"})
    public MetricRegistry metrics() {
        return this.metricRegistry;
    }

    @GET
    @Timed
    @Path(value="/names")
    @ApiOperation(value="Get all metrics keys/names")
    @RequiresPermissions(value={"metrics:allkeys"})
    @Produces(value={"application/json"})
    public Map<String, SortedSet<String>> metricNames() {
        return ImmutableMap.of((Object)"names", (Object)this.metricRegistry.getNames());
    }

    @GET
    @Timed
    @Path(value="/{metricName}")
    @ApiOperation(value="Get a single metric")
    @ApiResponses(value={@ApiResponse(code=404, message="No such metric")})
    @Produces(value={"application/json"})
    public Metric singleMetric(@ApiParam(name="metricName", required=true) @PathParam(value="metricName") String metricName) {
        this.checkPermission("metrics:read", metricName);
        Metric metric = (Metric)this.metricRegistry.getMetrics().get(metricName);
        if (metric == null) {
            String msg = "I do not have a metric called [" + metricName + "].";
            LOG.debug(msg);
            throw new NotFoundException(msg);
        }
        return metric;
    }

    @POST
    @Timed
    @Path(value="/multiple")
    @ApiOperation(value="Get the values of multiple metrics at once")
    @ApiResponses(value={@ApiResponse(code=400, message="Malformed body")})
    public String multipleMetrics(@ApiParam(name="Requested metrics", required=true) @Valid @NotNull MetricsReadRequest request) {
        Map metrics = this.metricRegistry.getMetrics();
        ArrayList metricsList = Lists.newArrayList();
        for (String name : request.metrics()) {
            Metric metric;
            if (!this.isPermitted("metrics:read", name) || (metric = (Metric)metrics.get(name)) == null) continue;
            metricsList.add(MetricUtils.map(name, metric));
        }
        return this.json(ImmutableMap.of((Object)"metrics", (Object)metricsList, (Object)"total", (Object)metricsList.size()));
    }

    @GET
    @Timed
    @Path(value="/namespace/{namespace}")
    @ApiOperation(value="Get all metrics of a namespace")
    @ApiResponses(value={@ApiResponse(code=404, message="No such metric namespace")})
    @Produces(value={"application/json"})
    public String byNamespace(@ApiParam(name="namespace", required=true) @PathParam(value="namespace") String namespace) {
        ArrayList metrics = Lists.newArrayList();
        for (Map.Entry e : this.metricRegistry.getMetrics().entrySet()) {
            String metricName = (String)e.getKey();
            if (!metricName.startsWith(namespace) || !this.isPermitted("metrics:read", metricName)) continue;
            try {
                Metric metric = (Metric)e.getValue();
                metrics.add(MetricUtils.map(metricName, metric));
            }
            catch (Exception ex) {
                LOG.warn("Could not read metric in namespace list.", (Throwable)ex);
            }
        }
        if (metrics.isEmpty()) {
            String msg = "No metrics with namespace [" + namespace + "] found.";
            LOG.debug(msg);
            throw new NotFoundException(msg);
        }
        return this.json(ImmutableMap.of((Object)"metrics", (Object)metrics, (Object)"total", (Object)metrics.size()));
    }

    @GET
    @Timed
    @Path(value="/{metricName}/history")
    @ApiOperation(value="Get history of a single metric", notes="The maximum retention time is currently only 5 minutes.")
    public String historicSingleMetric(@ApiParam(name="metricName", required=true) @PathParam(value="metricName") String metricName, @ApiParam(name="after", value="Only values for after this UTC timestamp (1970 epoch)") @QueryParam(value="after") @DefaultValue(value="-1") long after) {
        this.checkPermission("metrics:readhistory", metricName);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> obj = new ArrayList<BasicDBObject>();
        obj.add(new BasicDBObject("name", (Object)metricName));
        if (after != -1L) {
            obj.add(new BasicDBObject("$gt", (Object)new BasicDBObject("$gt", (Object)new Date(after))));
        }
        andQuery.put("$and", obj);
        DBCursor cursor = this.mongoConnection.getDatabase().getCollection("graylog2_metrics").find((DBObject)andQuery).sort((DBObject)new BasicDBObject("timestamp", (Object)1));
        HashMap metricsData = Maps.newHashMap();
        metricsData.put("name", metricName);
        ArrayList values = Lists.newArrayList();
        metricsData.put("values", values);
        while (cursor.hasNext()) {
            DBObject value = cursor.next();
            metricsData.put("node", value.get("node"));
            MetricType metricType = MetricType.valueOf(((String)value.get("type")).toUpperCase());
            HashMap dataPoint = Maps.newHashMap();
            values.add(dataPoint);
            dataPoint.put("timestamp", value.get("timestamp"));
            metricsData.put("type", metricType.toString().toLowerCase());
            switch (metricType) {
                case GAUGE: {
                    Object gaugeValue = value.get("value");
                    dataPoint.put("value", gaugeValue);
                    break;
                }
                case COUNTER: {
                    dataPoint.put("count", value.get("count"));
                    break;
                }
                case HISTOGRAM: {
                    dataPoint.put("75-percentile", value.get("75-percentile"));
                    dataPoint.put("95-percentile", value.get("95-percentile"));
                    dataPoint.put("98-percentile", value.get("98-percentile"));
                    dataPoint.put("99-percentile", value.get("99-percentile"));
                    dataPoint.put("999-percentile", value.get("999-percentile"));
                    dataPoint.put("max", value.get("max"));
                    dataPoint.put("min", value.get("min"));
                    dataPoint.put("mean", value.get("mean"));
                    dataPoint.put("median", value.get("median"));
                    dataPoint.put("std_dev", value.get("std_dev"));
                    break;
                }
                case METER: {
                    dataPoint.put("count", value.get("count"));
                    dataPoint.put("1-minute-rate", value.get("1-minute-rate"));
                    dataPoint.put("5-minute-rate", value.get("5-minute-rate"));
                    dataPoint.put("15-minute-rate", value.get("15-minute-rate"));
                    dataPoint.put("mean-rate", value.get("mean-rate"));
                    break;
                }
                case TIMER: {
                    dataPoint.put("count", value.get("count"));
                    dataPoint.put("rate-unit", value.get("rate-unit"));
                    dataPoint.put("1-minute-rate", value.get("1-minute-rate"));
                    dataPoint.put("5-minute-rate", value.get("5-minute-rate"));
                    dataPoint.put("15-minute-rate", value.get("15-minute-rate"));
                    dataPoint.put("mean-rate", value.get("mean-rate"));
                    dataPoint.put("duration-unit", value.get("duration-unit"));
                    dataPoint.put("75-percentile", value.get("75-percentile"));
                    dataPoint.put("95-percentile", value.get("95-percentile"));
                    dataPoint.put("98-percentile", value.get("98-percentile"));
                    dataPoint.put("99-percentile", value.get("99-percentile"));
                    dataPoint.put("999-percentile", value.get("999-percentile"));
                    dataPoint.put("max", value.get("max"));
                    dataPoint.put("min", value.get("min"));
                    dataPoint.put("mean", value.get("mean"));
                    dataPoint.put("median", value.get("median"));
                    dataPoint.put("stddev", value.get("stddev"));
                }
            }
        }
        return this.json(metricsData);
    }

    private String json(Object x) {
        try {
            return this.objectMapper.writeValueAsString(x);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while generating JSON", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    static enum MetricType {
        GAUGE,
        COUNTER,
        HISTOGRAM,
        METER,
        TIMER;

    }
}

