/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.ldap;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.net.ssl.TrustManager;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.resources.system.ldap.requests.LdapSettingsRequest;
import org.graylog2.rest.resources.system.ldap.requests.LdapTestConfigRequest;
import org.graylog2.rest.resources.system.ldap.responses.LdapSettingsResponse;
import org.graylog2.rest.resources.system.ldap.responses.LdapTestConfigResponse;
import org.graylog2.security.TrustAllX509TrustManager;
import org.graylog2.security.ldap.LdapConnector;
import org.graylog2.security.ldap.LdapSettingsImpl;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.ldap.LdapEntry;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@RequiresPermissions(value={"ldap:edit"})
@Api(value="System/LDAP", description="LDAP settings")
@Path(value="/system/ldap")
public class LdapResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LdapResource.class);
    @Inject
    private LdapSettingsService ldapSettingsService;
    @Inject
    private LdapSettingsImpl.Factory ldapSettingsFactory;
    @Inject
    private LdapConnector ldapConnector;
    @Inject
    private LdapUserAuthenticator ldapAuthenticator;

    @GET
    @Timed
    @ApiOperation(value="Get the LDAP configuration if it is configured")
    @Path(value="/settings")
    @Produces(value={"application/json"})
    public LdapSettingsResponse getLdapSettings() {
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        if (ldapSettings == null) {
            throw new NotFoundException();
        }
        return LdapSettingsResponse.create(ldapSettings.isEnabled(), ldapSettings.getSystemUserName(), ldapSettings.getSystemPassword(), ldapSettings.getUri(), ldapSettings.isUseStartTls(), ldapSettings.isTrustAllCertificates(), ldapSettings.isActiveDirectory(), ldapSettings.getSearchBase(), ldapSettings.getSearchPattern(), ldapSettings.getDisplayNameAttribute(), ldapSettings.getDefaultGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Timed
    @ApiOperation(value="Test LDAP Configuration")
    @Path(value="/test")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public LdapTestConfigResponse testLdapConfiguration(@ApiParam(name="Configuration to test", required=true) @Valid @NotNull LdapTestConfigRequest request) {
        LdapConnectionConfig config = new LdapConnectionConfig();
        URI ldapUri = request.ldapUri();
        config.setLdapHost(ldapUri.getHost());
        config.setLdapPort(ldapUri.getPort());
        config.setUseSsl(ldapUri.getScheme().startsWith("ldaps"));
        config.setUseTls(request.useStartTls());
        if (request.trustAllCertificates()) {
            config.setTrustManagers(new TrustManager[]{new TrustAllX509TrustManager()});
        }
        if (!Strings.isNullOrEmpty((String)request.systemUsername()) && !Strings.isNullOrEmpty((String)request.systemPassword())) {
            config.setName(request.systemUsername());
            config.setCredentials(request.systemPassword());
        }
        LdapNetworkConnection connection = null;
        try {
            try {
                connection = this.ldapConnector.connect(config);
            }
            catch (LdapException e) {
                LdapTestConfigResponse ldapTestConfigResponse = LdapTestConfigResponse.create(false, false, false, Collections.emptyMap(), e.getMessage());
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (IOException e2) {
                        LOG.warn("Unable to close LDAP connection.", (Throwable)e2);
                    }
                }
                return ldapTestConfigResponse;
            }
            if (null == connection) {
                LdapTestConfigResponse e = LdapTestConfigResponse.create(false, false, false, Collections.emptyMap(), "Could not connect to LDAP server");
                return e;
            }
            boolean connected = connection.isConnected();
            boolean systemAuthenticated = connection.isAuthenticated();
            if (request.testConnectOnly()) {
                LdapTestConfigResponse e2 = LdapTestConfigResponse.create(connected, systemAuthenticated, false, Collections.emptyMap());
                return e2;
            }
            String userPrincipalName = null;
            boolean loginAuthenticated = false;
            Map entryMap = Collections.emptyMap();
            String exception = null;
            try {
                LdapEntry entry = this.ldapConnector.search(connection, request.searchBase(), request.searchPattern(), request.principal(), request.activeDirectory());
                if (entry != null) {
                    userPrincipalName = entry.getDn();
                    entryMap = entry.getAttributes();
                }
            }
            catch (CursorException | LdapException e) {
                exception = e.getMessage();
            }
            try {
                loginAuthenticated = this.ldapConnector.authenticate(connection, userPrincipalName, request.password());
            }
            catch (Exception e) {
                exception = e.getMessage();
            }
            LdapTestConfigResponse ldapTestConfigResponse = LdapTestConfigResponse.create(connected, systemAuthenticated, loginAuthenticated, entryMap, exception);
            return ldapTestConfigResponse;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close LDAP connection.", (Throwable)e);
                }
            }
        }
    }

    @PUT
    @Timed
    @ApiOperation(value="Update the LDAP configuration")
    @Path(value="/settings")
    @Consumes(value={"application/json"})
    public void updateLdapSettings(@ApiParam(name="JSON body", required=true) @Valid @NotNull LdapSettingsRequest request) throws ValidationException {
        LdapSettings ldapSettings = (LdapSettings)Objects.firstNonNull((Object)this.ldapSettingsService.load(), (Object)this.ldapSettingsFactory.createEmpty());
        ldapSettings.setSystemUsername(request.systemUsername());
        ldapSettings.setSystemPassword(request.systemPassword());
        ldapSettings.setUri(request.ldapUri());
        ldapSettings.setUseStartTls(request.useStartTls());
        ldapSettings.setTrustAllCertificates(request.trustAllCertificates());
        ldapSettings.setActiveDirectory(request.activeDirectory());
        ldapSettings.setSearchPattern(request.searchPattern());
        ldapSettings.setSearchBase(request.searchBase());
        ldapSettings.setEnabled(request.enabled());
        ldapSettings.setDisplayNameAttribute(request.displayNameAttribute());
        ldapSettings.setDefaultGroup(request.defaultGroup());
        this.ldapSettingsService.save((Persisted)ldapSettings);
    }

    @DELETE
    @Timed
    @ApiOperation(value="Remove the LDAP configuration")
    @Path(value="/settings")
    public void deleteLdapSettings() {
        this.ldapSettingsService.delete();
    }
}

