/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.outputs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.database.NotFoundException;
import org.graylog2.outputs.MessageOutputFactory;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.rest.helpers.OutputFilter;
import org.graylog2.rest.models.system.outputs.responses.OutputSummary;
import org.graylog2.rest.resources.streams.outputs.AvailableOutputSummary;
import org.graylog2.rest.resources.streams.outputs.OutputListResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.outputs.CreateOutputRequest;
import org.graylog2.utilities.ConfigurationMapConverter;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Outputs", description="Manage outputs")
@Path(value="/system/outputs")
public class OutputResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(OutputResource.class);
    private final OutputService outputService;
    private final MessageOutputFactory messageOutputFactory;
    private final OutputFilter outputFilter;

    @Inject
    public OutputResource(OutputService outputService, MessageOutputFactory messageOutputFactory, OutputFilter outputFilter) {
        this.outputService = outputService;
        this.messageOutputFactory = messageOutputFactory;
        this.outputFilter = outputFilter;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all outputs")
    @RequiresPermissions(value={"stream_outputs:create"})
    @Produces(value={"application/json"})
    public OutputListResponse get() {
        this.checkPermission("outputs:read");
        HashSet<OutputSummary> outputs = new HashSet<OutputSummary>();
        for (Output output : this.outputService.loadAll()) {
            outputs.add(OutputSummary.create((String)output.getId(), (String)output.getTitle(), (String)output.getType(), (String)output.getCreatorUserId(), (DateTime)new DateTime((Object)output.getCreatedAt()), new HashMap(output.getConfiguration()), (String)output.getContentPack()));
        }
        return OutputListResponse.create(this.outputFilter.filterPasswordFields(outputs));
    }

    @GET
    @Path(value="/{outputId}")
    @Timed
    @ApiOperation(value="Get specific output")
    @RequiresPermissions(value={"outputs:create"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such output on this node.")})
    public OutputSummary get(@ApiParam(name="outputId", value="The id of the output we want.", required=true) @PathParam(value="outputId") String outputId) throws NotFoundException {
        this.checkPermission("outputs:read", outputId);
        try {
            Output output = this.outputService.load(outputId);
            return this.outputFilter.filterPasswordFields(OutputSummary.create((String)output.getId(), (String)output.getTitle(), (String)output.getType(), (String)output.getCreatorUserId(), (DateTime)new DateTime((Object)output.getCreatedAt()), (Map)output.getConfiguration(), (String)output.getContentPack()));
        }
        catch (MessageOutputConfigurationException e) {
            LOG.error("Unable to filter configuration fields of output {}: ", (Object)outputId, (Object)e);
            return null;
        }
    }

    @POST
    @Timed
    @ApiOperation(value="Create an output")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid output specification in input.", response=OutputSummary.class)})
    public Response create(@ApiParam(name="JSON body", required=true) CreateOutputRequest csor) throws ValidationException {
        this.checkPermission("outputs:create");
        AvailableOutputSummary outputSummary = this.messageOutputFactory.getAvailableOutputs().get(csor.type());
        if (outputSummary == null) {
            throw new ValidationException("type", "Invalid output type");
        }
        CreateOutputRequest createOutputRequest = CreateOutputRequest.create(csor.title(), csor.type(), ConfigurationMapConverter.convertValues(csor.configuration(), outputSummary.requestedConfiguration()), csor.streams());
        Output output = this.outputService.create(createOutputRequest, this.getCurrentUser().getName());
        URI outputUri = UriBuilder.fromResource(OutputResource.class).path("{outputId}").build(new Object[]{output.getId()});
        try {
            return Response.created((URI)outputUri).entity((Object)this.outputFilter.filterPasswordFields(OutputSummary.create((String)output.getId(), (String)output.getTitle(), (String)output.getType(), (String)output.getCreatorUserId(), (DateTime)new DateTime((Object)output.getCreatedAt()), new HashMap(output.getConfiguration()), (String)output.getContentPack()))).build();
        }
        catch (MessageOutputConfigurationException e) {
            LOG.error("Unable to filter configuration fields for output {}: ", (Object)output.getId(), (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{outputId}")
    @Timed
    @ApiOperation(value="Delete output")
    @RequiresPermissions(value={"outputs:terminate"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such stream/output on this node.")})
    public void delete(@ApiParam(name="outputId", value="The id of the output that should be deleted", required=true) @PathParam(value="outputId") String outputId) throws NotFoundException {
        this.checkPermission("outputs:terminate");
        Output output = this.outputService.load(outputId);
        this.outputService.destroy(output);
    }

    @GET
    @Path(value="/available")
    @Timed
    @ApiOperation(value="Get all available output modules")
    @RequiresPermissions(value={"streams:read"})
    @Produces(value={"application/json"})
    public Map<String, Map<String, AvailableOutputSummary>> available() {
        return ImmutableMap.of((Object)"types", this.messageOutputFactory.getAvailableOutputs());
    }
}

