/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.rest.resources.tools.RegexTesterResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.utilities.date.NaturalDateParser;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Path(value="/tools/natural_date_tester")
public class NaturalDateTesterResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RegexTesterResource.class);

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Map<String, String> naturalDateTester(@QueryParam(value="string") @NotEmpty String string) {
        try {
            return new NaturalDateParser().parse(string).asMap();
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            LOG.debug("Could not parse from natural date: " + string, (Throwable)e);
            throw new WebApplicationException((Throwable)e, 422);
        }
    }
}

