/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.inputs.extractors.SplitAndIndexExtractor;
import org.graylog2.rest.resources.tools.responses.SplitAndIndexTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/split_and_index_tester")
public class SplitAndIndexTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public SplitAndIndexTesterResponse splitAndIndexTester(@QueryParam(value="split_by") @NotNull String splitBy, @QueryParam(value="index") @Min(value=0L) int index, @QueryParam(value="string") @NotNull String string) {
        String cut = SplitAndIndexExtractor.cut(string, splitBy, index - 1);
        int[] positions = SplitAndIndexExtractor.getCutIndices(string, splitBy, index - 1);
        return SplitAndIndexTesterResponse.create(cut != null, cut, positions[0], positions[1]);
    }
}

