/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.plugin.Tools;
import org.graylog2.rest.resources.tools.responses.SubstringTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/substring_tester")
public class SubstringTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public SubstringTesterResponse substringTester(@QueryParam(value="begin_index") @Min(value=0L) int beginIndex, @QueryParam(value="end_index") @Min(value=1L) int endIndex, @QueryParam(value="string") @NotNull String string) {
        String cut = Tools.safeSubstring((String)string, (int)beginIndex, (int)endIndex);
        return SubstringTesterResponse.create(cut != null, cut, beginIndex, endIndex);
    }
}

