/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.savedsearches;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.savedsearches.SavedSearch;
import org.graylog2.savedsearches.SavedSearchImpl;
import org.graylog2.savedsearches.SavedSearchService;

public class SavedSearchServiceImpl
extends PersistedServiceImpl
implements SavedSearchService {
    @Inject
    public SavedSearchServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public List<SavedSearch> all() {
        ArrayList searches = Lists.newArrayList();
        List<DBObject> results = this.query(SavedSearchImpl.class, (DBObject)new BasicDBObject());
        for (DBObject o : results) {
            searches.add(new SavedSearchImpl((ObjectId)o.get("_id"), o.toMap()));
        }
        return searches;
    }

    @Override
    public SavedSearchImpl load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(SavedSearchImpl.class, id);
        if (o == null) {
            throw new NotFoundException();
        }
        return new SavedSearchImpl((ObjectId)o.get("_id"), o.toMap());
    }
}

