/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.streams.InvalidStreamRuleTypeException;
import org.graylog2.streams.StreamFaultManager;
import org.graylog2.streams.StreamListFingerprint;
import org.graylog2.streams.StreamMetrics;
import org.graylog2.streams.StreamRuleMatcherFactory;
import org.graylog2.streams.matchers.StreamRuleMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRouterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(StreamRouterEngine.class);
    private final List<Stream> streams;
    private final StreamFaultManager streamFaultManager;
    private final StreamMetrics streamMetrics;
    private final TimeLimiter timeLimiter;
    private final long streamProcessingTimeout;
    private final String fingerprint;
    private final Map<String, List<Rule>> presenceRules = Maps.newHashMap();
    private final Map<String, List<Rule>> exactRules = Maps.newHashMap();
    private final Map<String, List<Rule>> greaterRules = Maps.newHashMap();
    private final Map<String, List<Rule>> smallerRules = Maps.newHashMap();
    private final Map<String, List<Rule>> regexRules = Maps.newHashMap();
    private final Set<String> presenceFields = Sets.newHashSet();
    private final Set<String> exactFields = Sets.newHashSet();
    private final Set<String> greaterFields = Sets.newHashSet();
    private final Set<String> smallerFields = Sets.newHashSet();
    private final Set<String> regexFields = Sets.newHashSet();

    @Inject
    public StreamRouterEngine(@Assisted List<Stream> streams, @Assisted ExecutorService executorService, StreamFaultManager streamFaultManager, StreamMetrics streamMetrics) {
        this.streams = streams;
        this.streamFaultManager = streamFaultManager;
        this.streamMetrics = streamMetrics;
        this.timeLimiter = new SimpleTimeLimiter(executorService);
        this.streamProcessingTimeout = streamFaultManager.getStreamProcessingTimeout();
        this.fingerprint = new StreamListFingerprint(streams).getFingerprint();
        for (Stream stream : streams) {
            for (StreamRule streamRule : stream.getStreamRules()) {
                try {
                    Rule rule = new Rule(stream, streamRule);
                    switch (streamRule.getType()) {
                        case EXACT: {
                            this.addRule(this.exactRules, this.exactFields, streamRule.getField(), rule);
                            break;
                        }
                        case GREATER: {
                            this.addRule(this.greaterRules, this.greaterFields, streamRule.getField(), rule);
                            break;
                        }
                        case SMALLER: {
                            this.addRule(this.smallerRules, this.smallerFields, streamRule.getField(), rule);
                            break;
                        }
                        case REGEX: {
                            this.addRule(this.regexRules, this.regexFields, streamRule.getField(), rule);
                            break;
                        }
                        case PRESENCE: {
                            this.addRule(this.presenceRules, this.presenceFields, streamRule.getField(), rule);
                        }
                    }
                }
                catch (InvalidStreamRuleTypeException e) {
                    LOG.warn("Invalid stream rule type. Skipping matching for this rule. " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public List<Stream> getStreams() {
        return this.streams;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public List<Stream> match(Message message) {
        HashMap matches = Maps.newHashMap();
        HashSet timeouts = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        Set fieldNames = message.getFieldNames();
        this.matchRules(message, this.presenceFields, this.presenceRules, matches);
        this.matchRules(message, (Set<String>)Sets.intersection((Set)fieldNames, this.exactFields), this.exactRules, matches);
        this.matchRules(message, (Set<String>)Sets.intersection((Set)fieldNames, this.greaterFields), this.greaterRules, matches);
        this.matchRules(message, (Set<String>)Sets.intersection((Set)fieldNames, this.smallerFields), this.smallerRules, matches);
        this.matchRulesWithTimeout(message, (Set<String>)Sets.intersection((Set)fieldNames, this.regexFields), this.regexRules, matches, timeouts);
        for (Stream stream : timeouts) {
            this.streamFaultManager.registerFailure(stream);
        }
        for (Map.Entry entry : matches.entrySet()) {
            if (!((StreamMatch)entry.getValue()).isMatched()) continue;
            result.add(entry.getKey());
            this.streamMetrics.markIncomingMeter(((Stream)entry.getKey()).getId());
        }
        return result;
    }

    public List<StreamTestMatch> testMatch(Message message) {
        ArrayList matches = Lists.newArrayList();
        for (Stream stream : this.streams) {
            StreamTestMatch match = new StreamTestMatch(stream);
            for (StreamRule streamRule : stream.getStreamRules()) {
                try {
                    Rule rule = new Rule(stream, streamRule);
                    match.addRule(rule);
                }
                catch (InvalidStreamRuleTypeException e) {
                    LOG.warn("Invalid stream rule type. Skipping matching for this rule. " + e.getMessage(), (Throwable)e);
                }
            }
            match.matchMessage(message);
            matches.add(match);
        }
        return matches;
    }

    private void matchRules(Message message, Set<String> fields, Map<String, List<Rule>> rules, Map<Stream, StreamMatch> matches) {
        for (String field : fields) {
            for (Rule rule : rules.get(field)) {
                this.registerMatch(matches, rule.match(message));
            }
        }
    }

    private void matchRulesWithTimeout(final Message message, Set<String> fields, Map<String, List<Rule>> rules, Map<Stream, StreamMatch> matches, Set<Stream> timeouts) {
        for (String field : fields) {
            for (final Rule rule : rules.get(field)) {
                Callable<Stream> task = new Callable<Stream>(){

                    @Override
                    public Stream call() {
                        return rule.match(message);
                    }
                };
                try {
                    Stream match = (Stream)this.timeLimiter.callWithTimeout((Callable)task, this.streamProcessingTimeout, TimeUnit.MILLISECONDS, true);
                    this.registerMatch(matches, match);
                }
                catch (UncheckedTimeoutException e) {
                    timeouts.add(rule.getStream());
                }
                catch (Exception e) {
                    LOG.error("Unexpected stream rule exception.", (Throwable)e);
                }
            }
        }
    }

    private void registerMatch(Map<Stream, StreamMatch> matches, Stream match) {
        if (match != null) {
            if (!matches.containsKey(match)) {
                matches.put(match, new StreamMatch(match));
            }
            matches.get(match).increment();
        }
    }

    private void addRule(Map<String, List<Rule>> rules, Set<String> fields, String field, Rule rule) {
        fields.add(field);
        if (!rules.containsKey(field)) {
            rules.put(field, Lists.newArrayList((Object[])new Rule[]{rule}));
        } else {
            rules.get(field).add(rule);
        }
    }

    public static class StreamTestMatch {
        private final Stream stream;
        private final List<Rule> rules = Lists.newArrayList();
        private final Map<StreamRule, Boolean> matches = Maps.newHashMap();

        public StreamTestMatch(Stream stream) {
            this.stream = stream;
        }

        public void addRule(Rule rule) {
            this.rules.add(rule);
        }

        public void matchMessage(Message message) {
            for (Rule rule : this.rules) {
                Stream match = rule.match(message);
                this.matches.put(rule.getStreamRule(), match != null && match.equals(this.stream));
            }
        }

        public boolean isMatched() {
            return !this.matches.isEmpty() && !this.matches.values().contains(false);
        }

        public Stream getStream() {
            return this.stream;
        }

        public Map<StreamRule, Boolean> getMatches() {
            return this.matches;
        }
    }

    private class Rule {
        private final Stream stream;
        private final StreamRule rule;
        private final StreamRuleMatcher matcher;

        public Rule(Stream stream, StreamRule rule) throws InvalidStreamRuleTypeException {
            this.stream = stream;
            this.rule = rule;
            this.matcher = StreamRuleMatcherFactory.build(rule.getType());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Stream match(Message message) {
            try (Timer.Context timer = StreamRouterEngine.this.streamMetrics.getExecutionTimer(this.rule.getId()).time();){
                if (this.matcher.match(message, this.rule)) {
                    Stream stream2 = this.stream;
                    return stream2;
                }
                Stream stream = null;
                return stream;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error matching stream rule <" + this.rule.getType() + "/" + this.rule.getValue() + ">: " + e.getMessage(), (Throwable)e);
                }
                StreamRouterEngine.this.streamMetrics.markExceptionMeter(this.rule.getStreamId());
                return null;
            }
        }

        public StreamRule getStreamRule() {
            return this.rule;
        }

        public Stream getStream() {
            return this.stream;
        }
    }

    private class StreamMatch {
        private final int ruleCount;
        private int matches = 0;

        public StreamMatch(Stream stream) {
            this.ruleCount = stream.getStreamRules().size();
        }

        public void increment() {
            ++this.matches;
        }

        public boolean isMatched() {
            return this.ruleCount == this.matches;
        }
    }

    public static interface Factory {
        public StreamRouterEngine create(List<Stream> var1, ExecutorService var2);
    }
}

