/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats.mongo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.graylog2.system.stats.mongo.AutoValue_ServerStatus;
import org.graylog2.system.stats.mongo.AutoValue_ServerStatus_Connections;
import org.graylog2.system.stats.mongo.AutoValue_ServerStatus_Memory;
import org.graylog2.system.stats.mongo.AutoValue_ServerStatus_Network;
import org.joda.time.DateTime;

@JsonAutoDetect
public abstract class ServerStatus {
    @JsonProperty
    public abstract String host();

    @JsonProperty
    public abstract String version();

    @JsonProperty
    public abstract String process();

    @JsonProperty
    public abstract long pid();

    @JsonProperty
    public abstract int uptime();

    @JsonProperty
    public abstract long uptimeMillis();

    @JsonProperty
    public abstract int uptimeEstimate();

    @JsonProperty
    public abstract DateTime localTime();

    @JsonProperty
    public abstract Connections connections();

    @JsonProperty
    public abstract Network network();

    @JsonProperty
    public abstract Memory memory();

    public static ServerStatus create(String host, String version, String process, long pid, int uptime, long uptimeMillis, int uptimeEstimate, DateTime localTime, Connections connections, Network network, Memory memory) {
        return new AutoValue_ServerStatus(host, version, process, pid, uptime, uptimeMillis, uptimeEstimate, localTime, connections, network, memory);
    }

    @JsonAutoDetect
    public static abstract class Memory {
        @JsonProperty
        public abstract int bits();

        @JsonProperty
        public abstract int resident();

        @JsonProperty
        public abstract int virtual();

        @JsonProperty
        public abstract boolean supported();

        @JsonProperty
        public abstract int mapped();

        @JsonProperty
        public abstract int mappedWithJournal();

        public static Memory create(int bits, int resident, int virtual, boolean supported, int mapped, int mappedWithJournal) {
            return new AutoValue_ServerStatus_Memory(bits, resident, virtual, supported, mapped, mappedWithJournal);
        }
    }

    @JsonAutoDetect
    public static abstract class Network {
        @JsonProperty
        public abstract int bytesIn();

        @JsonProperty
        public abstract int bytesOut();

        @JsonProperty
        public abstract int numRequests();

        public static Network create(int bytesIn, int bytesOut, int numRequests) {
            return new AutoValue_ServerStatus_Network(bytesIn, bytesOut, numRequests);
        }
    }

    @JsonAutoDetect
    public static abstract class Connections {
        @JsonProperty
        public abstract int current();

        @JsonProperty
        public abstract int available();

        @JsonProperty
        @Nullable
        public abstract Long totalCreated();

        public static Connections create(int current, int available, @Nullable long totalCreated) {
            return new AutoValue_ServerStatus_Connections(current, available, totalCreated);
        }
    }
}

