/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.LimitedOptionalStringValidator;
import org.graylog2.database.validators.LimitedStringValidator;
import org.graylog2.database.validators.ListValidator;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="users")
public class UserImpl
extends PersistedImpl
implements User {
    private static final Logger LOG = LoggerFactory.getLogger(UserImpl.class);
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String EMAIL = "email";
    public static final String FULL_NAME = "full_name";
    public static final String PERMISSIONS = "permissions";
    public static final String PREFERENCES = "preferences";
    public static final String TIMEZONE = "timezone";
    public static final String EXTERNAL_USER = "external_user";
    public static final String SESSION_TIMEOUT = "session_timeout_ms";
    public static final String STARTPAGE = "startpage";
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int MAX_USERNAME_LENGTH = 100;
    public static final int MAX_EMAIL_LENGTH = 254;
    public static final int MAX_FULL_NAME_LENGTH = 200;

    public UserImpl(Map<String, Object> fields) {
        super(fields);
    }

    protected UserImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    public boolean isReadOnly() {
        return false;
    }

    public Map<String, Validator> getValidations() {
        return ImmutableMap.builder().put((Object)USERNAME, (Object)new LimitedStringValidator(1, 100)).put((Object)PASSWORD, (Object)new FilledStringValidator()).put((Object)EMAIL, (Object)new LimitedStringValidator(1, 254)).put((Object)FULL_NAME, (Object)new LimitedOptionalStringValidator(200)).put((Object)PERMISSIONS, (Object)new ListValidator()).build();
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }

    public String getFullName() {
        return String.valueOf(this.fields.get(FULL_NAME));
    }

    public void setFullName(String fullname) {
        this.fields.put(FULL_NAME, fullname);
    }

    public String getName() {
        return String.valueOf(this.fields.get(USERNAME));
    }

    public void setName(String username) {
        this.fields.put(USERNAME, username);
    }

    public String getEmail() {
        return Strings.nullToEmpty((String)((String)this.fields.get(EMAIL)));
    }

    public void setEmail(String email) {
        this.fields.put(EMAIL, email);
    }

    public List<String> getPermissions() {
        return (List)this.fields.get(PERMISSIONS);
    }

    public void setPermissions(List<String> permissions) {
        this.fields.put(PERMISSIONS, permissions);
    }

    public Map<String, Object> getPreferences() {
        return (Map)this.fields.get(PREFERENCES);
    }

    public void setPreferences(Map<String, Object> preferences) {
        this.fields.put(PREFERENCES, preferences);
    }

    public Map<String, String> getStartpage() {
        HashMap startpage = Maps.newHashMap();
        if (this.fields.containsKey(STARTPAGE)) {
            Map obj = (Map)this.fields.get(STARTPAGE);
            startpage.put("type", obj.get("type"));
            startpage.put("id", obj.get("id"));
        }
        return startpage;
    }

    public long getSessionTimeoutMs() {
        Object o = this.fields.get(SESSION_TIMEOUT);
        if (o != null && o instanceof Long) {
            return (Long)o;
        }
        return TimeUnit.HOURS.toMillis(8L);
    }

    public void setSessionTimeoutMs(long timeoutValue) {
        this.fields.put(SESSION_TIMEOUT, timeoutValue);
    }

    public String getHashedPassword() {
        return MoreObjects.firstNonNull(this.fields.get(PASSWORD), (Object)"").toString();
    }

    public void setHashedPassword(String hashedPassword) {
        this.fields.put(PASSWORD, hashedPassword);
    }

    public void setPassword(String password, String passwordSecret) {
        if (password == null || "".equals(password)) {
            this.setHashedPassword("");
        } else {
            String newPassword = new SimpleHash(HASH_ALGORITHM, (Object)password, (Object)passwordSecret).toString();
            this.setHashedPassword(newPassword);
        }
    }

    public boolean isUserPassword(String password, String passwordSecret) {
        String oldPasswordHash = new SimpleHash(HASH_ALGORITHM, (Object)password, (Object)passwordSecret).toString();
        return this.getHashedPassword().equals(oldPasswordHash);
    }

    public DateTimeZone getTimeZone() {
        Object o = this.fields.get(TIMEZONE);
        try {
            if (o != null) {
                return DateTimeZone.forID((String)o.toString());
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid timezone \"{}\" saved for user \"{}\"", o, (Object)this.getName());
        }
        return null;
    }

    public void setTimeZone(String timeZone) {
        DateTimeZone dateTimeZone;
        try {
            dateTimeZone = DateTimeZone.forID((String)((String)MoreObjects.firstNonNull((Object)timeZone, (Object)DateTimeZone.UTC.getID())));
        }
        catch (IllegalArgumentException e) {
            LOG.info("Invalid timezone \"{}\", falling back to UTC.", (Object)timeZone);
            dateTimeZone = DateTimeZone.UTC;
        }
        this.setTimeZone(dateTimeZone);
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.fields.put(TIMEZONE, timeZone.getID());
    }

    public boolean isExternalUser() {
        return Boolean.valueOf(String.valueOf(this.fields.get(EXTERNAL_USER)));
    }

    public void setExternal(boolean external) {
        this.fields.put(EXTERNAL_USER, external);
    }

    public boolean isLocalAdmin() {
        return false;
    }

    public void setStartpage(String type, String id) {
        HashMap startpage = Maps.newHashMap();
        if (type != null && id != null) {
            startpage.put("type", type);
            startpage.put("id", id);
        }
        this.fields.put(STARTPAGE, startpage);
    }

    public static class LocalAdminUser
    extends UserImpl {
        private final Configuration configuration;

        public LocalAdminUser(Configuration configuration) {
            super(null, Collections.emptyMap());
            this.configuration = configuration;
        }

        @Override
        public String getId() {
            return "local:admin";
        }

        @Override
        public String getFullName() {
            return "Administrator";
        }

        @Override
        public String getEmail() {
            return this.configuration.getRootEmail();
        }

        @Override
        public String getName() {
            return this.configuration.getRootUsername();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public boolean isExternalUser() {
            return false;
        }

        @Override
        public List<String> getPermissions() {
            return Collections.singletonList("*");
        }

        @Override
        public Map<String, Object> getPreferences() {
            return Collections.emptyMap();
        }

        @Override
        public long getSessionTimeoutMs() {
            return TimeUnit.HOURS.toMillis(8L);
        }

        @Override
        public DateTimeZone getTimeZone() {
            return this.configuration.getRootTimeZone();
        }

        @Override
        public boolean isLocalAdmin() {
            return true;
        }
    }
}

