/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.database.ValidationException;

public class ConfigurationMapConverter {
    public static Map<String, Object> convertValues(Map<String, Object> data, ConfigurationRequest configurationRequest) throws ValidationException {
        HashMap configuration = Maps.newHashMapWithExpectedSize((int)data.size());
        Map configurationFields = configurationRequest.asList();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object value;
            switch ((String)((Map)configurationFields.get(entry.getKey())).get("type")) {
                case "text": {
                    value = String.valueOf(entry.getValue());
                    break;
                }
                case "number": {
                    try {
                        value = Integer.parseInt(String.valueOf(entry.getValue()));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException(entry.getKey(), e.getMessage());
                    }
                }
                case "boolean": {
                    value = "true".equals(String.valueOf(entry.getValue()));
                    break;
                }
                case "dropdown": {
                    value = String.valueOf(entry.getValue());
                    break;
                }
                default: {
                    value = entry.getValue();
                }
            }
            configuration.put(entry.getKey(), value);
        }
        return configuration;
    }
}

