/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.PositiveLongValidator;
import java.net.URI;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTimeZone;

public class Configuration
extends BaseConfiguration {
    @Parameter(value="is_master", required=true)
    private boolean isMaster = true;
    @Parameter(value="password_secret", required=true)
    private String passwordSecret;
    @Parameter(value="rest_listen_uri", required=true)
    private URI restListenUri = URI.create("http://127.0.0.1:12900/");
    @Parameter(value="output_batch_size", required=true, validator=PositiveIntegerValidator.class)
    private int outputBatchSize = 500;
    @Parameter(value="output_flush_interval", required=true, validator=PositiveIntegerValidator.class)
    private int outputFlushInterval = 1;
    @Parameter(value="outputbuffer_processors", required=true, validator=PositiveIntegerValidator.class)
    private int outputBufferProcessors = 3;
    @Parameter(value="outputbuffer_processor_threads_max_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int outputBufferProcessorThreadsMaxPoolSize = 30;
    @Parameter(value="outputbuffer_processor_threads_core_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int outputBufferProcessorThreadsCorePoolSize = 3;
    @Parameter(value="outputbuffer_processor_keep_alive_time", validator=PositiveIntegerValidator.class)
    private int outputBufferProcessorKeepAliveTime = 5000;
    @Parameter(value="dead_letters_enabled")
    private boolean deadLettersEnabled = false;
    @Parameter(value="rules_file")
    private String droolsRulesFile;
    @Parameter(value="node_id_file")
    private String nodeIdFile = "/etc/graylog/server/node-id";
    @Parameter(value="root_username")
    private String rootUsername = "admin";
    @Parameter(value="root_password_sha2", required=true)
    private String rootPasswordSha2;
    @Parameter(value="root_timezone")
    private DateTimeZone rootTimeZone = DateTimeZone.UTC;
    @Parameter(value="root_email")
    private String rootEmail = "";
    @Parameter(value="allow_leading_wildcard_searches")
    private boolean allowLeadingWildcardSearches = false;
    @Parameter(value="allow_highlighting")
    private boolean allowHighlighting = false;
    @Parameter(value="enable_metrics_collection")
    private boolean metricsCollectionEnabled = false;
    @Parameter(value="lb_recognition_period_seconds", validator=PositiveIntegerValidator.class)
    private int loadBalancerRecognitionPeriodSeconds = 3;
    @Parameter(value="stream_processing_timeout", validator=PositiveLongValidator.class)
    private long streamProcessingTimeout = 2000L;
    @Parameter(value="stream_processing_max_faults", validator=PositiveIntegerValidator.class)
    private int streamProcessingMaxFaults = 3;
    @Parameter(value="output_module_timeout", validator=PositiveLongValidator.class)
    private long outputModuleTimeout = 10000L;
    @Parameter(value="output_fault_count_threshold", validator=PositiveLongValidator.class)
    private long outputFaultCountThreshold = 5L;
    @Parameter(value="output_fault_penalty_seconds", validator=PositiveLongValidator.class)
    private long outputFaultPenaltySeconds = 30L;
    @Parameter(value="stale_master_timeout", validator=PositiveIntegerValidator.class)
    private int staleMasterTimeout = 2000;
    @Parameter(value="ldap_connection_timeout", validator=PositiveIntegerValidator.class)
    private int ldapConnectionTimeout = 2000;
    @Parameter(value="alert_check_interval", validator=PositiveIntegerValidator.class)
    private int alertCheckInterval = 60;
    @Parameter(value="gc_warning_threshold")
    private Duration gcWarningThreshold = Duration.seconds((long)1L);
    @Parameter(value="default_message_output_class")
    private String defaultMessageOutputClass = "";

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setIsMaster(boolean is) {
        this.isMaster = is;
    }

    public String getPasswordSecret() {
        return this.passwordSecret.trim();
    }

    public int getOutputBatchSize() {
        return this.outputBatchSize;
    }

    public int getOutputFlushInterval() {
        return this.outputFlushInterval;
    }

    public int getOutputBufferProcessors() {
        return this.outputBufferProcessors;
    }

    public int getOutputBufferProcessorThreadsCorePoolSize() {
        return this.outputBufferProcessorThreadsCorePoolSize;
    }

    public int getOutputBufferProcessorThreadsMaxPoolSize() {
        return this.outputBufferProcessorThreadsMaxPoolSize;
    }

    public int getOutputBufferProcessorKeepAliveTime() {
        return this.outputBufferProcessorKeepAliveTime;
    }

    public String getDroolsRulesFile() {
        return this.droolsRulesFile;
    }

    public String getNodeIdFile() {
        return this.nodeIdFile;
    }

    public URI getRestListenUri() {
        return Tools.getUriWithDefaultPath((URI)Tools.getUriWithPort((URI)Tools.getUriWithScheme((URI)this.restListenUri, (String)this.getRestUriScheme()), (int)12900), (String)"/");
    }

    public String getRootUsername() {
        return this.rootUsername;
    }

    public String getRootPasswordSha2() {
        return this.rootPasswordSha2;
    }

    public DateTimeZone getRootTimeZone() {
        return this.rootTimeZone;
    }

    public String getRootEmail() {
        return this.rootEmail;
    }

    public boolean isAllowLeadingWildcardSearches() {
        return this.allowLeadingWildcardSearches;
    }

    public boolean isAllowHighlighting() {
        return this.allowHighlighting;
    }

    public boolean isMetricsCollectionEnabled() {
        return this.metricsCollectionEnabled;
    }

    public boolean isDeadLettersEnabled() {
        return this.deadLettersEnabled;
    }

    public int getLoadBalancerRecognitionPeriodSeconds() {
        return this.loadBalancerRecognitionPeriodSeconds;
    }

    public long getStreamProcessingTimeout() {
        return this.streamProcessingTimeout;
    }

    public int getStreamProcessingMaxFaults() {
        return this.streamProcessingMaxFaults;
    }

    public long getOutputModuleTimeout() {
        return this.outputModuleTimeout;
    }

    public long getOutputFaultCountThreshold() {
        return this.outputFaultCountThreshold;
    }

    public long getOutputFaultPenaltySeconds() {
        return this.outputFaultPenaltySeconds;
    }

    public int getStaleMasterTimeout() {
        return this.staleMasterTimeout;
    }

    public int getLdapConnectionTimeout() {
        return this.ldapConnectionTimeout;
    }

    public int getAlertCheckInterval() {
        return this.alertCheckInterval;
    }

    public Duration getGcWarningThreshold() {
        return this.gcWarningThreshold;
    }

    public String getDefaultMessageOutputClass() {
        return this.defaultMessageOutputClass;
    }
}

