/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import java.util.Set;
import javax.inject.Inject;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.shared.bindings.InstantiationService;

public class AlarmCallbackFactory {
    private InstantiationService instantiationService;
    private final Set<Class<? extends AlarmCallback>> availableAlarmCallbacks;

    @Inject
    public AlarmCallbackFactory(InstantiationService instantiationService, Set<Class<? extends AlarmCallback>> availableAlarmCallbacks) {
        this.instantiationService = instantiationService;
        this.availableAlarmCallbacks = availableAlarmCallbacks;
    }

    public AlarmCallback create(AlarmCallbackConfiguration configuration) throws ClassNotFoundException, AlarmCallbackConfigurationException {
        AlarmCallback alarmCallback = this.create(configuration.getType());
        alarmCallback.initialize(configuration.getConfiguration());
        return alarmCallback;
    }

    public AlarmCallback create(String type) throws ClassNotFoundException {
        for (Class<? extends AlarmCallback> availableClass : this.availableAlarmCallbacks) {
            if (!availableClass.getCanonicalName().equals(type)) continue;
            return this.create(availableClass);
        }
        throw new RuntimeException("No class found for type " + type);
    }

    public AlarmCallback create(Class<? extends AlarmCallback> alarmCallbackClass) {
        return (AlarmCallback)this.instantiationService.getInstance(alarmCallbackClass);
    }
}

