/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.alerts.Alert;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="alerts")
public class AlertImpl
extends PersistedImpl
implements Alert {
    private static final Logger LOG = LoggerFactory.getLogger(AlertImpl.class);
    public static final int MAX_LIST_COUNT = 300;
    public static final int REST_CHECK_CACHE_SECONDS = 30;

    protected AlertImpl(Map<String, Object> fields) {
        super(fields);
    }

    protected AlertImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap map = Maps.newHashMap();
        DateTime triggeredAt = new DateTime(this.fields.get("triggered_at"), DateTimeZone.UTC);
        map.put("id", this.fields.get("_id").toString());
        map.put("condition_id", this.fields.get("condition_id"));
        map.put("stream_id", this.fields.get("stream_id"));
        map.put("description", this.fields.get("description"));
        map.put("condition_parameters", this.fields.get("condition_parameters"));
        map.put("triggered_at", Tools.getISO8601String((DateTime)triggeredAt));
        return map;
    }

    public Map<String, Validator> getValidations() {
        return Collections.emptyMap();
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }
}

