/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts.types;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValueAlertCondition
extends AbstractAlertCondition {
    private static final Logger LOG = LoggerFactory.getLogger(FieldValueAlertCondition.class);
    private final int time;
    private final ThresholdType thresholdType;
    private final Number threshold;
    private final CheckType type;
    private final String field;
    private final DecimalFormat decimalFormat;
    private final Searches searches;
    private List<Message> searchHits = Collections.emptyList();

    @AssistedInject
    public FieldValueAlertCondition(Searches searches, @Assisted Stream stream, @Nullable @Assisted String id, @Assisted DateTime createdAt, @Assisted(value="userid") String creatorUserId, @Assisted Map<String, Object> parameters) {
        super(stream, id, AbstractAlertCondition.Type.FIELD_VALUE, createdAt, creatorUserId, parameters);
        this.searches = searches;
        this.decimalFormat = new DecimalFormat("#.###");
        this.time = (Integer)parameters.get("time");
        this.thresholdType = ThresholdType.valueOf(((String)parameters.get("threshold_type")).toUpperCase());
        this.threshold = (Number)parameters.get("threshold");
        this.type = CheckType.valueOf(((String)parameters.get("type")).toUpperCase());
        this.field = (String)parameters.get("field");
    }

    public String getDescription() {
        return "time: " + this.time + ", field: " + this.field + ", check type: " + this.type.toString().toLowerCase() + ", threshold_type: " + this.thresholdType.toString().toLowerCase() + ", threshold: " + this.decimalFormat.format(this.threshold) + ", grace: " + this.grace;
    }

    @Override
    protected AbstractAlertCondition.CheckResult runCheck() {
        this.searchHits = Collections.emptyList();
        ArrayList summaries = Lists.newArrayList();
        try {
            double result;
            String filter = "streams:" + this.stream.getId();
            FieldStatsResult fieldStatsResult = this.searches.fieldStats(this.field, "*", filter, new RelativeRange(this.time * 60));
            if (this.getBacklog() != null && this.getBacklog() > 0) {
                this.searchHits = Lists.newArrayList();
                for (ResultMessage resultMessage : fieldStatsResult.getSearchHits()) {
                    Message msg = new Message(resultMessage.getMessage());
                    this.searchHits.add(msg);
                    summaries.add(new MessageSummary(resultMessage.getIndex(), msg));
                }
            }
            if (fieldStatsResult.getCount() == 0L) {
                LOG.debug("Alert check <{}> did not match any messages. Returning not triggered.", (Object)this.type);
                return new AbstractAlertCondition.CheckResult(false);
            }
            switch (this.type) {
                case MEAN: {
                    result = fieldStatsResult.getMean();
                    break;
                }
                case MIN: {
                    result = fieldStatsResult.getMin();
                    break;
                }
                case MAX: {
                    result = fieldStatsResult.getMax();
                    break;
                }
                case SUM: {
                    result = fieldStatsResult.getSum();
                    break;
                }
                case STDDEV: {
                    result = fieldStatsResult.getStdDeviation();
                    break;
                }
                default: {
                    LOG.error("No such field value check type: [{}]. Returning not triggered.", (Object)this.type);
                    return new AbstractAlertCondition.CheckResult(false);
                }
            }
            LOG.debug("Alert check <{}> result: [{}]", (Object)this.id, (Object)result);
            if (Double.isInfinite(result)) {
                LOG.debug("Infinite value. Returning not triggered.");
                return new AbstractAlertCondition.CheckResult(false);
            }
            boolean triggered = false;
            switch (this.thresholdType) {
                case HIGHER: {
                    triggered = result > this.threshold.doubleValue();
                    break;
                }
                case LOWER: {
                    boolean bl = triggered = result < this.threshold.doubleValue();
                }
            }
            if (triggered) {
                String resultDescription = "Field " + this.field + " had a " + (Object)((Object)this.type) + " of " + this.decimalFormat.format(result) + " in the last " + this.time + " minutes with trigger condition " + (Object)((Object)this.thresholdType) + " than " + this.decimalFormat.format(this.threshold) + ". " + "(Current grace time: " + this.grace + " minutes)";
                return new AbstractAlertCondition.CheckResult(true, this, resultDescription, Tools.iso8601(), summaries);
            }
            return new AbstractAlertCondition.CheckResult(false);
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Invalid timerange.", (Throwable)e);
            return null;
        }
        catch (InvalidRangeFormatException e) {
            LOG.error("Invalid timerange format.", (Throwable)e);
            return null;
        }
        catch (Searches.FieldTypeException e) {
            LOG.debug("Field [{}] seems not to have a numerical type or doesn't even exist at all. Returning not triggered.", (Object)this.field, (Object)e);
            return new AbstractAlertCondition.CheckResult(false);
        }
    }

    public List<Message> getSearchHits() {
        return this.searchHits;
    }

    public static interface Factory {
        public FieldValueAlertCondition createAlertCondition(Stream var1, String var2, DateTime var3, @Assisted(value="userid") String var4, Map<String, Object> var5);
    }

    public static enum ThresholdType {
        LOWER,
        HIGHER;

    }

    public static enum CheckType {
        MEAN,
        MIN,
        MAX,
        SUM,
        STDDEV;

    }
}

