/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.google.common.base.Strings;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import org.graylog2.Configuration;
import org.graylog2.outputs.BlockingBatchedESOutput;
import org.graylog2.outputs.DefaultMessageOutput;
import org.graylog2.outputs.GelfOutput;
import org.graylog2.outputs.LoggingOutput;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.outputs.MessageOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageOutputBindings
extends Graylog2Module {
    private static final Logger LOG = LoggerFactory.getLogger(MessageOutputBindings.class);
    private final Configuration configuration;

    public MessageOutputBindings(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        Class<? extends MessageOutput> defaultMessageOutputClass = this.getDefaultMessageOutputClass(BlockingBatchedESOutput.class);
        LOG.debug("Using default message output class: {}", (Object)defaultMessageOutputClass.getCanonicalName());
        this.bind(MessageOutput.class).annotatedWith(DefaultMessageOutput.class).to(defaultMessageOutputClass).in(Scopes.SINGLETON);
        MapBinder outputMapBinder = this.outputsMapBinder();
        this.installOutput(outputMapBinder, GelfOutput.class, GelfOutput.Factory.class);
        this.installOutput(outputMapBinder, LoggingOutput.class, LoggingOutput.Factory.class);
    }

    private Class<? extends MessageOutput> getDefaultMessageOutputClass(Class<? extends MessageOutput> fallbackClass) {
        if (Strings.isNullOrEmpty((String)this.configuration.getDefaultMessageOutputClass())) {
            return fallbackClass;
        }
        try {
            Class<?> defaultMessageOutputClass = Class.forName(this.configuration.getDefaultMessageOutputClass());
            if (MessageOutput.class.isAssignableFrom(defaultMessageOutputClass)) {
                LOG.info("Using {} as default message output", (Object)defaultMessageOutputClass.getCanonicalName());
                return defaultMessageOutputClass;
            }
            LOG.warn("Class \"{}\" is not a subclass of \"{}\". Using \"{}\" as default message output", new Object[]{this.configuration.getDefaultMessageOutputClass(), MessageOutput.class.getCanonicalName(), fallbackClass.getCanonicalName()});
            return fallbackClass;
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Unable to find default message output class \"{}\", using \"{}\"", (Object)this.configuration.getDefaultMessageOutputClass(), (Object)fallbackClass.getCanonicalName());
            return fallbackClass;
        }
    }
}

