/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.buffers.processors;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.buffers.OutputBuffer;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProcessBufferProcessor
extends ProcessBufferProcessor {
    private final Configuration configuration;
    private final ServerStatus serverStatus;
    private final Journal journal;
    private static final Logger LOG = LoggerFactory.getLogger(ServerProcessBufferProcessor.class);
    private final OutputBuffer outputBuffer;
    private final Meter filteredOutMessages;
    private final List<MessageFilter> filterRegistry;

    @Inject
    public ServerProcessBufferProcessor(MetricRegistry metricRegistry, Set<MessageFilter> filterRegistry, Configuration configuration, ServerStatus serverStatus, OutputBuffer outputBuffer, Journal journal) {
        super(metricRegistry);
        this.configuration = configuration;
        this.serverStatus = serverStatus;
        this.journal = journal;
        this.filterRegistry = Ordering.from((Comparator)new Comparator<MessageFilter>(){

            @Override
            public int compare(MessageFilter filter1, MessageFilter filter2) {
                return ComparisonChain.start().compare(filter1.getPriority(), filter2.getPriority()).compare((Comparable)((Object)filter1.getName()), (Comparable)((Object)filter2.getName())).result();
            }
        }).immutableSortedCopy(filterRegistry);
        this.outputBuffer = outputBuffer;
        this.filteredOutMessages = metricRegistry.meter(MetricRegistry.name(ProcessBufferProcessor.class, (String[])new String[]{"filteredOutMessages"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(@Nonnull Message msg) {
        if (this.filterRegistry.size() == 0) {
            throw new RuntimeException("Empty filter registry!");
        }
        for (MessageFilter filter : this.filterRegistry) {
            String timerName = MetricRegistry.name(filter.getClass(), (String[])new String[]{"executionTime"});
            Timer timer = this.metricRegistry.timer(timerName);
            Timer.Context timerContext = timer.time();
            try {
                LOG.debug("Applying filter [{}] on message <{}>.", (Object)filter.getName(), (Object)msg.getId());
                if (!filter.filter(msg)) continue;
                LOG.debug("Filter [{}] marked message <{}> to be discarded. Dropping message.", (Object)filter.getName(), (Object)msg.getId());
                this.filteredOutMessages.mark();
                this.journal.markJournalOffsetCommitted(msg.getJournalOffset());
                return;
            }
            catch (Exception e) {
                LOG.error("Could not apply filter [" + filter.getName() + "] on message <" + msg.getId() + ">: ", (Throwable)e);
            }
            finally {
                long elapsedNanos = timerContext.stop();
                msg.recordTiming(this.serverStatus, timerName, elapsedNanos);
            }
        }
        LOG.debug("Finished processing message. Writing to output buffer.");
        this.outputBuffer.insertBlocking(msg);
    }

    List<MessageFilter> getFilterRegistry() {
        return this.filterRegistry;
    }
}

