/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters.blacklist;

import com.atlassian.ip.IPMatcher;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.graylog2.filters.blacklist.FilterDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistIpMatcherCondition
extends FilterDescription {
    private static final Logger LOG = LoggerFactory.getLogger(BlacklistIpMatcherCondition.class);
    private IPMatcher ipMatcher;

    @JsonProperty
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.ipMatcher = IPMatcher.builder().addPatternOrHost(pattern).build();
    }

    public boolean matchesInetAddress(InetAddress otherSource) {
        try {
            return this.ipMatcher.matches(otherSource);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlacklistIpMatcherCondition)) {
            return false;
        }
        BlacklistIpMatcherCondition that = (BlacklistIpMatcherCondition)o;
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }
}

