/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Named;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.jobs.OptimizeIndexJob;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetIndexReadOnlyJob
extends SystemJob {
    private static final Logger log = LoggerFactory.getLogger(SetIndexReadOnlyJob.class);
    private final Indices indices;
    private final boolean disableIndexOptimization;
    private final OptimizeIndexJob.Factory optimizeIndexJobFactory;
    private final SystemJobManager systemJobManager;
    private final String index;
    private final ActivityWriter activityWriter;

    @AssistedInject
    public SetIndexReadOnlyJob(Indices indices, @Named(value="disable_index_optimization") boolean disableIndexOptimization, SystemJobManager systemJobManager, OptimizeIndexJob.Factory optimizeIndexJobFactory, ActivityWriter activityWriter, ServerStatus serverStatus, @Assisted String index) {
        super(serverStatus);
        this.indices = indices;
        this.disableIndexOptimization = disableIndexOptimization;
        this.optimizeIndexJobFactory = optimizeIndexJobFactory;
        this.systemJobManager = systemJobManager;
        this.index = index;
        this.activityWriter = activityWriter;
    }

    @Override
    public void execute() {
        log.info("Flushing old index <{}>.", (Object)this.index);
        this.indices.flush(this.index);
        log.info("Setting old index <{}> to read-only.", (Object)this.index);
        this.indices.setReadOnly(this.index);
        this.activityWriter.write(new Activity("Flushed and make <" + this.index + "> read only.", SetIndexReadOnlyJob.class));
        if (!this.disableIndexOptimization) {
            try {
                this.systemJobManager.submit(this.optimizeIndexJobFactory.create(this.index));
            }
            catch (SystemJobConcurrencyException e) {
                log.error("Cannot optimize index <" + this.index + ">.", (Throwable)e);
            }
        }
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int maxConcurrency() {
        return 1000;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Sets an index to read only for performance and optionally triggers an optimization.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public SetIndexReadOnlyJob create(String var1);
    }
}

