/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.search.SearchHit;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.Mapping;
import org.graylog2.indexer.indices.IndexStatistics;
import org.graylog2.plugin.indexer.retention.IndexManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Indices
implements IndexManagement {
    private static final Logger LOG = LoggerFactory.getLogger(Indices.class);
    private final Client c;
    private final ElasticsearchConfiguration configuration;

    @Inject
    public Indices(Node node, ElasticsearchConfiguration configuration) {
        this.c = node.client();
        this.configuration = configuration;
    }

    public void move(String source, String target) {
        MatchAllQueryBuilder qb = QueryBuilders.matchAllQuery();
        SearchResponse scrollResp = (SearchResponse)this.c.prepareSearch(new String[]{source}).setSearchType(SearchType.SCAN).setScroll(new TimeValue(10000L)).setQuery((QueryBuilder)qb).setSize(350).execute().actionGet();
        while ((scrollResp = (SearchResponse)this.c.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet()).getHits().hits().length != 0) {
            BulkRequestBuilder request = this.c.prepareBulk();
            for (SearchHit hit : scrollResp.getHits()) {
                Map doc = hit.getSource();
                String id = (String)doc.remove("_id");
                request.add((IndexRequest)this.manualIndexRequest(target, doc, id).request());
            }
            request.setConsistencyLevel(WriteConsistencyLevel.ONE);
            request.setReplicationType(ReplicationType.ASYNC);
            if (request.numberOfActions() <= 0) continue;
            BulkResponse response = (BulkResponse)this.c.bulk((BulkRequest)request.request()).actionGet();
            LOG.info("Moving index <{}> to <{}>: Bulk indexed {} messages, took {} ms, failures: {}", new Object[]{source, target, response.getItems().length, response.getTookInMillis(), response.hasFailures()});
            if (!response.hasFailures()) continue;
            throw new RuntimeException("Failed to move a message. Check your indexer log.");
        }
    }

    public void delete(String indexName) {
        this.c.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet();
    }

    public void close(String indexName) {
        this.c.admin().indices().close(new CloseIndexRequest(new String[]{indexName})).actionGet();
    }

    public long numberOfMessages(String indexName) throws IndexNotFoundException {
        Map<String, IndexStats> indices = this.getAll();
        IndexStats index = indices.get(indexName);
        if (index == null) {
            throw new IndexNotFoundException();
        }
        return index.getPrimaries().getDocs().getCount();
    }

    public Map<String, IndexStats> getAll() {
        ActionFuture isr = this.c.admin().indices().stats(new IndicesStatsRequest().all());
        return ((IndicesStatsResponse)isr.actionGet()).getIndices();
    }

    public long getTotalNumberOfMessages() {
        return ((CountResponse)this.c.count(new CountRequest(new String[]{this.allIndicesAlias()})).actionGet()).getCount();
    }

    public long getTotalSize() {
        return ((IndicesStatsResponse)this.c.admin().indices().stats((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{this.allIndicesAlias()})).actionGet()).getTotal().getStore().getSize().getMb();
    }

    public String allIndicesAlias() {
        return this.configuration.getIndexPrefix() + "_*";
    }

    public boolean exists(String index) {
        ActionFuture existsFuture = this.c.admin().indices().exists(new IndicesExistsRequest(new String[]{index}));
        return ((IndicesExistsResponse)existsFuture.actionGet()).isExists();
    }

    public boolean aliasExists(String alias) {
        return ((AliasesExistResponse)this.c.admin().indices().aliasesExist(new GetAliasesRequest(alias)).actionGet()).exists();
    }

    public String aliasTarget(String alias) {
        return (String)((GetAliasesResponse)this.c.admin().indices().getAliases(new GetAliasesRequest(alias)).actionGet()).getAliases().keysIt().next();
    }

    public boolean create(String indexName) {
        HashMap settings = Maps.newHashMap();
        settings.put("number_of_shards", this.configuration.getShards());
        settings.put("number_of_replicas", this.configuration.getReplicas());
        HashMap keywordLowercase = Maps.newHashMap();
        keywordLowercase.put("tokenizer", "keyword");
        keywordLowercase.put("filter", "lowercase");
        settings.put("index.analysis.analyzer.analyzer_keyword", keywordLowercase);
        CreateIndexRequest cir = new CreateIndexRequest(indexName);
        cir.settings((Map)settings);
        ActionFuture createFuture = this.c.admin().indices().create(cir);
        boolean acknowledged = ((CreateIndexResponse)createFuture.actionGet()).isAcknowledged();
        if (!acknowledged) {
            return false;
        }
        PutMappingRequest mappingRequest = Mapping.getPutMappingRequest(this.c, indexName, this.configuration.getAnalyzer());
        return ((PutMappingResponse)this.c.admin().indices().putMapping(mappingRequest).actionGet()).isAcknowledged();
    }

    public ImmutableMap<String, IndexMetaData> getMetadata() {
        HashMap metaData = Maps.newHashMap();
        for (ObjectObjectCursor next : ((ClusterStateResponse)this.c.admin().cluster().state(new ClusterStateRequest()).actionGet()).getState().getMetaData().indices()) {
            metaData.put(next.key, next.value);
        }
        return ImmutableMap.copyOf((Map)metaData);
    }

    public Set<String> getAllMessageFields() {
        HashSet fields = Sets.newHashSet();
        ClusterStateRequest csr = new ClusterStateRequest().blocks(true).nodes(true).indices(new String[]{this.allIndicesAlias()});
        ClusterState cs = ((ClusterStateResponse)this.c.admin().cluster().state(csr).actionGet()).getState();
        for (ObjectObjectCursor m : cs.getMetaData().indices()) {
            try {
                MappingMetaData mmd = ((IndexMetaData)m.value).mapping("message");
                if (mmd == null) continue;
                Map mapping = (Map)mmd.getSourceAsMap().get("properties");
                fields.addAll(mapping.keySet());
            }
            catch (Exception e) {
                LOG.error("Error while trying to get fields of <" + m.index + ">", (Throwable)e);
            }
        }
        return fields;
    }

    private IndexRequestBuilder manualIndexRequest(String index, Map<String, Object> doc, String id) {
        IndexRequestBuilder b = new IndexRequestBuilder(this.c);
        b.setIndex(index);
        b.setId(id);
        b.setSource(doc);
        b.setOpType(IndexRequest.OpType.INDEX);
        b.setType("message");
        b.setConsistencyLevel(WriteConsistencyLevel.ONE);
        return b;
    }

    public void setReadOnly(String index) {
        ImmutableSettings.Builder sb = ImmutableSettings.builder();
        sb.put("index.blocks.write", true);
        sb.put("index.blocks.read", false);
        sb.put("index.blocks.metadata", false);
        this.c.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{index}).settings(sb.build())).actionGet();
    }

    public void flush(String index) {
        FlushRequest flush = new FlushRequest(new String[]{index});
        flush.force(true);
        flush.full(false);
        this.c.admin().indices().flush(new FlushRequest(new String[]{index}).force(true)).actionGet();
    }

    public void reopenIndex(String index) {
        UpdateSettingsRequest settings = new UpdateSettingsRequest(new String[]{index});
        settings.settings(Collections.singletonMap("graylog2_reopened", true));
        this.c.admin().indices().updateSettings(settings).actionGet();
        this.c.admin().indices().open(new OpenIndexRequest(new String[]{index})).actionGet();
    }

    public boolean isReopened(String indexName) {
        ClusterState clusterState = ((ClusterStateResponse)this.c.admin().cluster().state(new ClusterStateRequest()).actionGet()).getState();
        IndexMetaData metaData = (IndexMetaData)clusterState.getMetaData().getIndices().get((Object)indexName);
        if (metaData == null) {
            return false;
        }
        return this.checkForReopened(metaData);
    }

    protected Boolean checkForReopened(IndexMetaData metaData) {
        return metaData.getSettings().getAsBoolean("index.graylog2_reopened", Boolean.valueOf(false));
    }

    public Set<String> getClosedIndices() {
        HashSet closedIndices = Sets.newHashSet();
        ClusterStateRequest csr = new ClusterStateRequest().nodes(false).routingTable(false).blocks(false).metaData(true);
        ClusterState state = ((ClusterStateResponse)this.c.admin().cluster().state(csr).actionGet()).getState();
        UnmodifiableIterator it = state.getMetaData().getIndices().valuesIt();
        while (it.hasNext()) {
            IndexMetaData indexMeta = (IndexMetaData)it.next();
            if (!indexMeta.getIndex().startsWith(this.configuration.getIndexPrefix()) || !indexMeta.getState().equals((Object)IndexMetaData.State.CLOSE)) continue;
            closedIndices.add(indexMeta.getIndex());
        }
        return closedIndices;
    }

    public Set<String> getReopenedIndices() {
        HashSet reopenedIndices = Sets.newHashSet();
        ClusterStateRequest csr = new ClusterStateRequest().nodes(false).routingTable(false).blocks(false).metaData(true);
        ClusterState state = ((ClusterStateResponse)this.c.admin().cluster().state(csr).actionGet()).getState();
        UnmodifiableIterator it = state.getMetaData().getIndices().valuesIt();
        while (it.hasNext()) {
            IndexMetaData indexMeta = (IndexMetaData)it.next();
            if (!indexMeta.getIndex().startsWith(this.configuration.getIndexPrefix()) || !this.checkForReopened(indexMeta).booleanValue()) continue;
            reopenedIndices.add(indexMeta.getIndex());
        }
        return reopenedIndices;
    }

    public IndexStatistics getIndexStats(String index) {
        IndexStatistics stats = new IndexStatistics();
        try {
            IndicesStatsResponse indicesStatsResponse = (IndicesStatsResponse)this.c.admin().indices().stats(new IndicesStatsRequest().all()).actionGet();
            IndexStats indexStats = indicesStatsResponse.getIndex(index);
            if (indexStats == null) {
                return null;
            }
            stats.setPrimaries(indexStats.getPrimaries());
            stats.setTotal(indexStats.getTotal());
            for (ShardStats shardStats : indexStats.getShards()) {
                stats.addShardRouting(shardStats.getShardRouting());
            }
        }
        catch (ElasticsearchException e) {
            return null;
        }
        return stats;
    }

    public boolean cycleAlias(String aliasName, String targetIndex) {
        return ((IndicesAliasesResponse)this.c.admin().indices().prepareAliases().addAlias(targetIndex, aliasName).execute().actionGet()).isAcknowledged();
    }

    public boolean cycleAlias(String aliasName, String targetIndex, String oldIndex) {
        return ((IndicesAliasesResponse)this.c.admin().indices().prepareAliases().removeAlias(oldIndex, aliasName).addAlias(targetIndex, aliasName).execute().actionGet()).isAcknowledged();
    }

    public void optimizeIndex(String index) {
        OptimizeRequest or = new OptimizeRequest(new String[]{index});
        or.maxNumSegments(this.configuration.getIndexOptimizationMaxNumSegments());
        or.onlyExpungeDeletes(false);
        or.flush(true);
        or.waitForMerge(true);
        this.c.admin().indices().optimize(or).actionGet();
    }
}

