/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="index_ranges")
public class IndexRangeImpl
extends PersistedImpl
implements IndexRange {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRangeImpl.class);

    public IndexRangeImpl(Map<String, Object> fields) {
        super(fields);
    }

    protected IndexRangeImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    @Override
    public String getIndexName() {
        return (String)this.fields.get("index");
    }

    @Override
    public DateTime getCalculatedAt() {
        if (this.fields.containsKey("calculated_at")) {
            int ts = (Integer)this.fields.get("calculated_at");
            long unixMs = (long)ts * 1000L;
            return new DateTime(unixMs, DateTimeZone.UTC);
        }
        return null;
    }

    @Override
    public DateTime getStart() {
        int ts = (Integer)this.fields.get("start");
        long unixMs = (long)ts * 1000L;
        return new DateTime(unixMs, DateTimeZone.UTC);
    }

    @Override
    public int getCalculationTookMs() {
        if (this.fields.containsKey("took_ms")) {
            return (Integer)this.fields.get("took_ms");
        }
        return -1;
    }

    public Map<String, Validator> getValidations() {
        return Collections.emptyMap();
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }

    @Override
    @JsonValue
    public Map<String, Object> asMap() {
        int calculationTookMs;
        HashMap fields = Maps.newHashMap();
        fields.put("index", this.getIndexName());
        fields.put("starts", this.getStart());
        DateTime calculatedAt = this.getCalculatedAt();
        if (calculatedAt != null) {
            fields.put("calculated_at", calculatedAt);
        }
        if ((calculationTookMs = this.getCalculationTookMs()) >= 0) {
            fields.put("calculation_took_ms", calculationTookMs);
        }
        return fields;
    }
}

