/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;

public class DateHistogramResult
extends HistogramResult {
    private final DateHistogramFacet result;
    private final Searches.DateHistogramInterval interval;

    public DateHistogramResult(DateHistogramFacet result, String originalQuery, BytesReference builtQuery, Searches.DateHistogramInterval interval, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.result = result;
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Long> getResults() {
        TreeMap results = Maps.newTreeMap();
        for (DateHistogramFacet.Entry e : this.result) {
            results.put(e.getTime() / 1000L, e.getCount());
        }
        return results;
    }
}

