/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsStatsResult
extends IndexQueryResult {
    private final TermsStatsFacet facet;

    public TermsStatsResult(TermsStatsFacet facet, String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.facet = facet;
    }

    public List<Map<String, Object>> getResults() {
        ArrayList results = Lists.newArrayList();
        for (TermsStatsFacet.Entry e : this.facet.getEntries()) {
            HashMap resultMap = Maps.newHashMap();
            resultMap.put("key_field", e.getTerm().toString());
            resultMap.put("count", e.getCount());
            resultMap.put("min", e.getMin());
            resultMap.put("max", e.getMax());
            resultMap.put("total", e.getTotal());
            resultMap.put("total_count", e.getTotalCount());
            resultMap.put("mean", e.getMean());
            results.add(resultMap);
        }
        Collections.sort(results, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                double o2Mean;
                double o1Mean = (Double)o1.get("mean");
                if (o1Mean > (o2Mean = ((Double)o2.get("mean")).doubleValue())) {
                    return -1;
                }
                if (o1Mean < o2Mean) {
                    return 1;
                }
                return 0;
            }
        });
        return results;
    }
}

