/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches.timeranges;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class AbsoluteRange
implements TimeRange {
    private final DateTime from;
    private final DateTime to;

    public AbsoluteRange(DateTime from, DateTime to) {
        this.from = from;
        this.to = to;
    }

    public AbsoluteRange(String from, String to) throws InvalidRangeParametersException {
        if (from == null || from.isEmpty() || to == null || to.isEmpty()) {
            throw new InvalidRangeParametersException();
        }
        try {
            this.from = from.contains("T") ? DateTime.parse((String)from, (DateTimeFormatter)ISODateTimeFormat.dateTime()) : DateTime.parse((String)from, (DateTimeFormatter)Tools.timeFormatterWithOptionalMilliseconds());
            this.to = to.contains("T") ? DateTime.parse((String)to, (DateTimeFormatter)ISODateTimeFormat.dateTime()) : DateTime.parse((String)to, (DateTimeFormatter)Tools.timeFormatterWithOptionalMilliseconds());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRangeParametersException();
        }
    }

    @Override
    public TimeRange.Type getType() {
        return TimeRange.Type.ABSOLUTE;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.of((Object)"type", (Object)this.getType().toString().toLowerCase(), (Object)"from", (Object)this.getFrom(), (Object)"to", (Object)this.getTo());
    }

    @Override
    public DateTime getFrom() {
        return this.from;
    }

    @Override
    public DateTime getTo() {
        return this.to;
    }

    public Map<String, DateTime> getLimits() {
        return ImmutableMap.of((Object)"from", (Object)this.getFrom(), (Object)"to", (Object)this.getTo());
    }
}

