/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.primitives.Ints;
import java.util.Map;
import org.graylog2.inputs.converters.SyslogPriUtilities;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.Converter;

public class SyslogPriFacilityConverter
extends Converter {
    public SyslogPriFacilityConverter(Map<String, Object> config) {
        super(Converter.Type.SYSLOG_PRI_FACILITY, config);
    }

    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        Integer priority = Ints.tryParse((String)value);
        if (priority == null) {
            return value;
        }
        return Tools.syslogFacilityToReadable((int)SyslogPriUtilities.facilityFromPriority(priority));
    }

    public boolean buildsMultipleFields() {
        return false;
    }
}

