/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.plugin.inputs.Converter;

public class TokenizerConverter
extends Converter {
    private static final Pattern p = Pattern.compile("[a-zA-Z0-9_-]*");
    private static final Pattern kvPattern = Pattern.compile("\\s?=\\s?");
    private static final Pattern spacePattern = Pattern.compile(" ");
    private static final Pattern quotedValuePattern = Pattern.compile("([a-zA-Z0-9_-]+=\"[^\"]+\")");
    private static final CharMatcher QUOTE_MATCHER = CharMatcher.is((char)'\"').precomputed();
    private static final CharMatcher EQUAL_SIGN_MATCHER = CharMatcher.is((char)'=').precomputed();

    public TokenizerConverter(Map<String, Object> config) {
        super(Converter.Type.TOKENIZER, config);
    }

    public Object convert(String value) {
        HashMap fields;
        block3: {
            String nmsg;
            block4: {
                if (value == null || value.isEmpty()) {
                    return value;
                }
                fields = Maps.newHashMap();
                if (!value.contains("=")) break block3;
                nmsg = kvPattern.matcher(value).replaceAll("=");
                if (!nmsg.contains("=\"")) break block4;
                Matcher m = quotedValuePattern.matcher(nmsg);
                while (m.find()) {
                    String[] kv = m.group(1).split("=");
                    if (kv.length != 2 || !p.matcher(kv[0]).matches()) continue;
                    fields.put(kv[0].trim(), QUOTE_MATCHER.removeFrom((CharSequence)kv[1]).trim());
                }
                break block3;
            }
            String[] parts = spacePattern.split(nmsg);
            if (parts == null) break block3;
            for (String part : parts) {
                String[] kv;
                if (!part.contains("=") || EQUAL_SIGN_MATCHER.countIn((CharSequence)part) != 1 || (kv = part.split("=")).length != 2 || !p.matcher(kv[0]).matches() || fields.containsKey(kv[0])) continue;
                fields.put(kv[0].trim(), kv[1].trim());
            }
        }
        return fields;
    }

    public boolean buildsMultipleFields() {
        return true;
    }
}

