/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.resources.streams.outputs.AvailableOutputSummary;
import org.graylog2.shared.bindings.InstantiationService;

public class MessageOutputFactory {
    private final InstantiationService instantiationService;
    private final Map<String, MessageOutput.Factory<? extends MessageOutput>> availableOutputs;

    @Inject
    public MessageOutputFactory(InstantiationService instantiationService, Map<String, MessageOutput.Factory<? extends MessageOutput>> availableOutputs) {
        this.instantiationService = instantiationService;
        this.availableOutputs = availableOutputs;
    }

    public MessageOutput fromStreamOutput(Output output, Stream stream, Configuration configuration) throws MessageOutputConfigurationException {
        return (MessageOutput)this.availableOutputs.get(output.getType()).create(stream, configuration);
    }

    public Map<String, AvailableOutputSummary> getAvailableOutputs() {
        HashMap<String, AvailableOutputSummary> result = new HashMap<String, AvailableOutputSummary>(this.availableOutputs.size());
        for (Map.Entry<String, MessageOutput.Factory<? extends MessageOutput>> messageOutputEntry : this.availableOutputs.entrySet()) {
            MessageOutput.Factory<? extends MessageOutput> messageOutputFactoryClass = messageOutputEntry.getValue();
            MessageOutput.Descriptor descriptor = messageOutputFactoryClass.getDescriptor();
            AvailableOutputSummary availableOutputSummary = AvailableOutputSummary.create(descriptor.getName(), messageOutputEntry.getKey(), descriptor.getHumanName(), descriptor.getLinkToDocs(), messageOutputFactoryClass.getConfig().getRequestedConfiguration());
            result.put(messageOutputEntry.getKey(), availableOutputSummary);
        }
        return result;
    }

    public MessageOutput.Factory<? extends MessageOutput> get(String type) {
        return this.availableOutputs.get(type);
    }
}

