/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.github.joschi.jadconfig.util.Size;
import com.google.common.eventbus.EventBus;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.ThrottleState;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.journal.Journal;
import org.graylog2.shared.journal.KafkaJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleStateUpdaterThread
extends Periodical {
    private static final Logger log = LoggerFactory.getLogger(ThrottleStateUpdaterThread.class);
    private final KafkaJournal journal;
    private final ProcessBuffer processBuffer;
    private final EventBus eventBus;
    private final Size retentionSize;
    private final NotificationService notificationService;
    private final ServerStatus serverStatus;
    private boolean firstRun = true;
    private long logStartOffset;
    private long logEndOffset;
    private long previousLogEndOffset;
    private long previousReadOffset;
    private long currentReadOffset;
    private long currentTs;
    private long prevTs;

    @Inject
    public ThrottleStateUpdaterThread(Journal journal, ProcessBuffer processBuffer, EventBus eventBus, NotificationService notificationService, ServerStatus serverStatus, @Named(value="message_journal_max_size") Size retentionSize) {
        this.processBuffer = processBuffer;
        this.eventBus = eventBus;
        this.retentionSize = retentionSize;
        this.notificationService = notificationService;
        this.serverStatus = serverStatus;
        this.journal = journal instanceof KafkaJournal ? (KafkaJournal)journal : null;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean startOnThisNode() {
        return this.journal != null;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 1;
    }

    public int getPeriodSeconds() {
        return 1;
    }

    protected Logger getLogger() {
        return log;
    }

    public void doRun() {
        Notification notification;
        double journalUtilizationPercentage;
        ThrottleState throttleState = new ThrottleState();
        long committedOffset = this.journal.getCommittedOffset();
        this.prevTs = this.currentTs;
        this.currentTs = System.nanoTime();
        this.previousLogEndOffset = this.logEndOffset;
        this.previousReadOffset = this.currentReadOffset;
        this.logStartOffset = this.journal.getLogStartOffset();
        this.logEndOffset = this.journal.getLogEndOffset() - 1L;
        this.currentReadOffset = this.journal.getNextReadOffset() - 1L;
        if (this.firstRun) {
            this.firstRun = false;
            return;
        }
        throttleState.appendEventsPerSec = (long)Math.floor((double)(this.logEndOffset - this.previousLogEndOffset) / ((double)(this.currentTs - this.prevTs) / 1.0E9));
        throttleState.readEventsPerSec = (long)Math.floor((double)(this.currentReadOffset - this.previousReadOffset) / ((double)(this.currentTs - this.prevTs) / 1.0E9));
        throttleState.journalSize = this.journal.size();
        throttleState.journalSizeLimit = this.retentionSize.toBytes();
        throttleState.processBufferCapacity = this.processBuffer.getRemainingCapacity();
        throttleState.uncommittedJournalEntries = committedOffset == Long.MIN_VALUE ? (this.journal.size() == 0L ? 0L : this.logEndOffset - this.logStartOffset) : this.logEndOffset - committedOffset;
        log.debug("ThrottleState: {}", (Object)throttleState);
        this.journal.setThrottleState(throttleState);
        this.eventBus.post((Object)throttleState);
        double d = journalUtilizationPercentage = throttleState.journalSizeLimit > 0L ? (double)(throttleState.journalSize * 100L / throttleState.journalSizeLimit) : 0.0;
        if (journalUtilizationPercentage > 95.0) {
            notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.JOURNAL_UTILIZATION_TOO_HIGH).addSeverity(Notification.Severity.URGENT).addDetail("journal_utilization_percentage", journalUtilizationPercentage);
            this.notificationService.publishIfFirst(notification);
        }
        if (this.journal.getPurgedSegmentsInLastRetention() > 0) {
            notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.JOURNAL_UNCOMMITTED_MESSAGES_DELETED).addSeverity(Notification.Severity.URGENT);
            this.notificationService.publishIfFirst(notification);
        }
    }
}

