/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.helpers;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.outputs.MessageOutputFactory;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.rest.models.system.outputs.responses.OutputSummary;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OutputFilter.class);
    private static final String PASSWORD_ATTRIBUTE = TextField.Attribute.IS_PASSWORD.toString().toLowerCase();
    private final MessageOutputFactory messageOutputFactory;

    @Inject
    public OutputFilter(MessageOutputFactory messageOutputFactory) {
        this.messageOutputFactory = messageOutputFactory;
    }

    public Set<OutputSummary> filterPasswordFields(Set<OutputSummary> outputs) {
        HashSet data = Sets.newHashSet();
        for (OutputSummary output : outputs) {
            try {
                data.add(this.filterPasswordFields(output));
            }
            catch (MessageOutputConfigurationException e) {
                LOG.error("Unable to filter configuration fields for output {}: ", (Object)output.id(), (Object)e);
            }
        }
        return data;
    }

    public OutputSummary filterPasswordFields(OutputSummary output) throws MessageOutputConfigurationException {
        ConfigurationRequest requestedConfiguration;
        Map data = output.configuration();
        MessageOutput.Factory<? extends MessageOutput> factory = this.messageOutputFactory.get(output.type());
        if (null == factory) {
            throw new MessageOutputConfigurationException("Couldn't find output of type " + output.type());
        }
        try {
            requestedConfiguration = factory.getConfig().getRequestedConfiguration();
        }
        catch (Exception e) {
            throw new MessageOutputConfigurationException("Couldn't retrieve requested configuration for output " + output.title());
        }
        for (Map.Entry entry : data.entrySet()) {
            if (!requestedConfiguration.getField((String)entry.getKey()).getAttributes().contains(PASSWORD_ATTRIBUTE)) continue;
            data.put(entry.getKey(), "********");
        }
        return OutputSummary.create((String)output.id(), (String)output.title(), (String)output.type(), (String)output.creatorUserId(), (DateTime)output.createdAt(), (Map)data, (String)output.contentPack());
    }
}

