/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.rules;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.rest.resources.streams.responses.SingleStreamRuleSummaryResponse;
import org.graylog2.rest.resources.streams.responses.StreamRuleListResponse;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.hibernate.validator.constraints.NotEmpty;

@RequiresAuthentication
@Api(value="StreamRules", description="Manage stream rules")
@Path(value="/streams/{streamid}/rules")
public class StreamRuleResource
extends RestResource {
    private final StreamRuleService streamRuleService;
    private final StreamService streamService;

    @Inject
    public StreamRuleResource(StreamRuleService streamRuleService, StreamService streamService) {
        this.streamRuleService = streamRuleService;
        this.streamService = streamService;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a stream rule")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamId);
        Stream stream = this.streamService.load(streamId);
        StreamRule streamRule = this.streamRuleService.create(streamId, cr);
        String id = this.streamService.save((Persisted)streamRule);
        SingleStreamRuleSummaryResponse response = SingleStreamRuleSummaryResponse.create(id);
        URI streamRuleUri = UriBuilder.fromResource(StreamRuleResource.class).path("{streamRuleId}").build(new Object[]{streamId, id});
        return Response.created((URI)streamRuleUri).entity((Object)response).build();
    }

    @PUT
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Update a stream rule")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream or stream rule not found."), @ApiResponse(code=400, message="Invalid JSON Body.")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SingleStreamRuleSummaryResponse update(@ApiParam(name="streamid", value="The stream id this rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", value="The stream rule id we are updating", required=true) @PathParam(value="streamRuleId") String streamRuleId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamid);
        StreamRule streamRule = this.streamRuleService.load(streamRuleId);
        if (!streamRule.getStreamId().equals(streamid)) {
            throw new NotFoundException();
        }
        StreamRuleType streamRuleType = StreamRuleType.fromInteger((int)cr.type());
        if (null == streamRuleType) {
            throw new BadRequestException("Unknown stream rule type " + cr.type());
        }
        streamRule.setField(cr.field());
        streamRule.setType(streamRuleType);
        streamRule.setInverted(Boolean.valueOf(cr.inverted()));
        streamRule.setValue(cr.value());
        this.streamRuleService.save((Persisted)streamRule);
        return SingleStreamRuleSummaryResponse.create(streamRule.getId());
    }

    @POST
    @Path(value="/{streamRuleId}")
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public SingleStreamRuleSummaryResponse updateDeprecated(@PathParam(value="streamid") String streamid, @PathParam(value="streamRuleId") String streamRuleId, @Valid @NotNull CreateStreamRuleRequest cr) throws NotFoundException, ValidationException {
        return this.update(streamid, streamRuleId, cr);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all stream rules")
    @Produces(value={"application/json"})
    public StreamRuleListResponse get(@ApiParam(name="streamid", value="The id of the stream whose stream rules we want.", required=true) @PathParam(value="streamid") String streamid) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        List<StreamRule> streamRules = this.streamRuleService.loadForStream(stream);
        return StreamRuleListResponse.create(streamRules.size(), streamRules);
    }

    @GET
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Get a single stream rules")
    @Produces(value={"application/json"})
    public StreamRule get(@ApiParam(name="streamid", value="The id of the stream whose stream rule we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", value="The stream rule id we are getting", required=true) @PathParam(value="streamRuleId") String streamRuleId) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        return this.streamRuleService.load(streamRuleId);
    }

    @DELETE
    @Path(value="/{streamRuleId}")
    @Timed
    @ApiOperation(value="Delete a stream rule")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream rule not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public void delete(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="streamRuleId", required=true) @PathParam(value="streamRuleId") @NotEmpty String streamRuleId) throws NotFoundException {
        this.checkPermission("streams:edit", streamid);
        StreamRule streamRule = this.streamRuleService.load(streamRuleId);
        if (!streamRule.getStreamId().equals(streamid)) {
            throw new NotFoundException();
        }
        this.streamRuleService.destroy((Persisted)streamRule);
    }
}

