/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/Cluster", description="Node discovery")
@Path(value="/system/cluster")
@Produces(value={"application/json"})
public class ClusterResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterResource.class);
    private final NodeService nodeService;
    private final NodeId nodeId;

    @Inject
    public ClusterResource(NodeService nodeService, NodeId nodeId) {
        this.nodeService = nodeService;
        this.nodeId = nodeId;
    }

    @GET
    @Timed
    @Path(value="/nodes")
    @ApiOperation(value="List all active nodes in this cluster.")
    public Map<String, Object> nodes() {
        ArrayList nodeList = Lists.newArrayList();
        Map<String, Node> nodes = this.nodeService.allActive(Node.Type.SERVER);
        for (Map.Entry<String, Node> e : nodes.entrySet()) {
            nodeList.add(this.nodeSummary(e.getValue()));
        }
        return ImmutableMap.of((Object)"total", (Object)nodes.size(), (Object)"nodes", (Object)nodeList);
    }

    @GET
    @Timed
    @Path(value="/node")
    @ApiOperation(value="Information about this node.", notes="This is returning information of this node in context to its state in the cluster. Use the system API of the node itself to get system information.")
    public Node node() throws NodeNotFoundException {
        return this.nodeService.byNodeId(this.nodeId);
    }

    @GET
    @Timed
    @Path(value="/nodes/{nodeId}")
    @ApiOperation(value="Information about a node.", notes="This is returning information of a node in context to its state in the cluster. Use the system API of the node itself to get system information.")
    @ApiResponses(value={@ApiResponse(code=404, message="Node not found.")})
    public Node node(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") String nodeId) throws NodeNotFoundException {
        if (nodeId == null || nodeId.isEmpty()) {
            LOG.error("Missing nodeId. Returning HTTP 400.");
            throw new BadRequestException();
        }
        return this.nodeService.byNodeId(nodeId);
    }

    private Map<String, Object> nodeSummary(Node node) {
        HashMap m = Maps.newHashMap();
        m.put("node_id", node.getNodeId());
        m.put("type", node.getType().toString().toLowerCase());
        m.put("is_master", node.isMaster());
        m.put("transport_address", node.getTransportAddress());
        m.put("last_seen", Tools.getISO8601String((DateTime)node.getLastSeen()));
        m.put("short_node_id", node.getShortNodeId());
        return m;
    }
}

