/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.stats.ClusterStats;
import org.graylog2.system.stats.ClusterStatsService;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.mongo.MongoStats;

@Api(value="System/ClusterStats", description="Cluster stats")
@Path(value="/system/cluster/stats")
@Produces(value={"application/json"})
public class ClusterStatsResource
extends RestResource {
    private final ClusterStatsService clusterStatsService;

    @Inject
    public ClusterStatsResource(ClusterStatsService clusterStatsService) {
        this.clusterStatsService = clusterStatsService;
    }

    @GET
    @Timed
    @ApiOperation(value="Cluster status information.", notes="This resource returns information about the Graylog cluster.")
    public ClusterStats systemStats() {
        return this.clusterStatsService.clusterStats();
    }

    @GET
    @Path(value="/elasticsearch")
    @Timed
    @ApiOperation(value="Elasticsearch information.", notes="This resource returns information about the Elasticsearch Cluster.")
    public ElasticsearchStats elasticsearchStats() {
        return this.clusterStatsService.elasticsearchStats();
    }

    @GET
    @Path(value="/mongo")
    @Timed
    @ApiOperation(value="MongoDB information.", notes="This resource returns information about MongoDB.")
    public MongoStats mongoStats() {
        return this.clusterStatsService.mongoStats();
    }
}

