/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.resources.system.responses.GrokPatternList;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/system/grok")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="System/Grok", description="Manage grok patterns")
public class GrokResource
extends RestResource {
    private final GrokPatternService grokPatternService;

    @Inject
    public GrokResource(GrokPatternService grokPatternService) {
        this.grokPatternService = grokPatternService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all existing grok patterns")
    public GrokPatternList listGrokPatterns() {
        this.checkPermission("inputs:read");
        return GrokPatternList.create(this.grokPatternService.loadAll());
    }

    @GET
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Get the existing grok pattern")
    public GrokPattern listPattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId) throws NotFoundException {
        this.checkPermission("inputs:read");
        return this.grokPatternService.load(patternId);
    }

    @POST
    @Timed
    @ApiOperation(value="Add a new named pattern")
    public Response createPattern(@ApiParam(name="pattern", required=true) @Valid @NotNull GrokPattern pattern) throws ValidationException {
        this.checkPermission("inputs:create");
        GrokPattern newPattern = this.grokPatternService.save(pattern);
        URI patternUri = UriBuilder.fromMethod(GrokResource.class, (String)"listPattern").build(new Object[]{newPattern.id});
        return Response.created((URI)patternUri).entity((Object)newPattern).build();
    }

    @PUT
    @Timed
    @ApiOperation(value="Add a list of new patterns")
    public Response bulkUpdatePatterns(@ApiParam(name="patterns", required=true) @NotNull GrokPatternList patternList) throws ValidationException {
        this.checkPermission("inputs:create");
        for (GrokPattern pattern : patternList.patterns()) {
            if (this.grokPatternService.validate(pattern)) continue;
            throw new ValidationException("Invalid pattern " + pattern + ". Did not save any patterns.");
        }
        for (GrokPattern pattern : patternList.patterns()) {
            this.grokPatternService.save(pattern);
        }
        return Response.accepted().build();
    }

    @PUT
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Update an existing pattern")
    public GrokPattern updatePattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId, @ApiParam(name="pattern", required=true) GrokPattern pattern) throws NotFoundException, ValidationException {
        this.checkPermission("inputs:edit");
        GrokPattern oldPattern = this.grokPatternService.load(patternId);
        oldPattern.name = pattern.name;
        oldPattern.pattern = pattern.pattern;
        return this.grokPatternService.save(oldPattern);
    }

    @DELETE
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Remove an existing pattern by id")
    public void removePattern(@PathParam(value="patternId") String patternId) {
        this.checkPermission("inputs:edit");
        if (this.grokPatternService.delete(patternId) == 0) {
            throw new javax.ws.rs.NotFoundException();
        }
    }
}

