/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableSet;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.requests.InputLaunchRequest;
import org.graylog2.rest.models.system.inputs.responses.InputStateSummary;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.rest.models.system.inputs.responses.InputsList;
import org.graylog2.rest.resources.system.inputs.responses.InputCreated;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Inputs", description="Message inputs of this node")
@Path(value="/system/inputs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InputsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputsResource.class);
    private final InputService inputService;
    private final InputRegistry inputRegistry;
    private final MessageInputFactory messageInputFactory;
    private final InputLauncher inputLauncher;

    @Inject
    public InputsResource(InputService inputService, InputRegistry inputRegistry, MessageInputFactory messageInputFactory, InputLauncher inputLauncher) {
        this.inputService = inputService;
        this.inputRegistry = inputRegistry;
        this.messageInputFactory = messageInputFactory;
        this.inputLauncher = inputLauncher;
    }

    @GET
    @Timed
    @ApiOperation(value="Get information of a single input on this node")
    @Path(value="/{inputId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public InputSummary single(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        this.checkPermission("inputs:read", inputId);
        MessageInput input = this.inputRegistry.getRunningInput(inputId);
        if (input == null) {
            LOG.info("Input [{}]\u00a0not found. Returning HTTP 404.", (Object)inputId);
            throw new NotFoundException();
        }
        return InputSummary.create((String)input.getTitle(), (String)input.getPersistId(), (Boolean)input.isGlobal(), (String)input.getName(), (String)input.getContentPack(), (String)input.getId(), (DateTime)input.getCreatedAt(), (String)input.getClass().getCanonicalName(), (String)input.getCreatorUserId(), (Map)input.getAttributesWithMaskedPasswords(), (Map)input.getStaticFields());
    }

    @GET
    @Timed
    @ApiOperation(value="Get all inputs of this node")
    public InputsList list() {
        ImmutableSet.Builder inputStates = ImmutableSet.builder();
        for (IOState inputState : this.inputRegistry.getInputStates()) {
            if (!this.isPermitted("inputs:read", ((MessageInput)inputState.getStoppable()).getId())) continue;
            inputStates.add((Object)this.getInputStateSummary((IOState<MessageInput>)inputState));
        }
        return InputsList.create((Set)inputStates.build());
    }

    private InputStateSummary getInputStateSummary(IOState<MessageInput> inputState) {
        MessageInput messageInput = (MessageInput)inputState.getStoppable();
        return InputStateSummary.create((String)messageInput.getId(), (String)inputState.getState().toString(), (DateTime)inputState.getStartedAt(), (String)inputState.getDetailedMessage(), (InputSummary)InputSummary.create((String)messageInput.getTitle(), (String)messageInput.getPersistId(), (Boolean)messageInput.isGlobal(), (String)messageInput.getName(), (String)messageInput.getContentPack(), (String)messageInput.getId(), (DateTime)messageInput.getCreatedAt(), (String)messageInput.getClass().getCanonicalName(), (String)messageInput.getCreatorUserId(), (Map)messageInput.getAttributesWithMaskedPasswords(), (Map)messageInput.getStaticFields()));
    }

    @POST
    @Timed
    @ApiOperation(value="Launch input on this node", response=InputCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input type registered"), @ApiResponse(code=400, message="Missing or invalid configuration"), @ApiResponse(code=400, message="Type is exclusive and already has input running")})
    public Response create(@ApiParam(name="JSON body", required=true) @Valid @NotNull InputLaunchRequest lr) throws ValidationException {
        MessageInput input;
        this.checkPermission("inputs:create");
        try {
            String nodeId = lr.node() != null ? lr.node() : this.serverStatus.getNodeId().toString();
            input = this.messageInputFactory.create(lr, this.getCurrentUser().getName(), nodeId);
            input.checkConfiguration();
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", (Throwable)e);
            throw new NotFoundException((Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input configuration.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        if (input.isExclusive() && this.inputRegistry.hasTypeRunning(input.getClass())) {
            String error = "Type is exclusive and already has input running.";
            LOG.error("Type is exclusive and already has input running.");
            throw new BadRequestException("Type is exclusive and already has input running.");
        }
        Input mongoInput = this.getInput(input);
        String id = this.inputService.save(mongoInput);
        input.setPersistId(id);
        if (input.isGlobal().booleanValue() || input.getNodeId().equals(this.serverStatus.getNodeId().toString())) {
            input.initialize();
            this.inputLauncher.launch(input);
        }
        URI inputUri = UriBuilder.fromResource(InputsResource.class).path("{inputId}").build(new Object[]{id});
        return Response.created((URI)inputUri).entity((Object)InputCreated.create(id)).build();
    }

    private Input getInput(MessageInput input) throws ValidationException {
        Map inputData = input.asMap();
        Input mongoInput = input.getId() != null ? this.inputService.create(input.getId(), inputData) : this.inputService.create(inputData);
        return mongoInput;
    }

    @DELETE
    @Timed
    @Path(value="/{inputId}")
    @ApiOperation(value="Terminate input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public void terminate(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        this.checkPermission("inputs:terminate", inputId);
        MessageInput messageInput = this.inputRegistry.getRunningInput(inputId);
        if (messageInput == null) {
            LOG.info("Cannot terminate input. Input not found.");
            throw new NotFoundException();
        }
        this.inputRegistry.remove(messageInput);
        if (this.serverStatus.hasCapability(ServerStatus.Capability.MASTER) || !messageInput.isGlobal().booleanValue()) {
            try {
                Input input = this.inputService.find(messageInput.getId());
                this.inputService.destroy(input);
            }
            catch (org.graylog2.database.NotFoundException e) {
                LOG.warn("Input not found while deleting it: ", (Throwable)e);
            }
        }
    }

    @PUT
    @Timed
    @Path(value="/{inputId}")
    @ApiOperation(value="Update input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="Missing or invalid input configuration.")})
    public Response update(@ApiParam(name="JSON body", required=true) @Valid @NotNull InputLaunchRequest lr, @ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws ValidationException, org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        try {
            Input oldInput = this.inputService.find(inputId);
            MessageInput messageInput = this.messageInputFactory.create(lr, this.getCurrentUser().getName(), oldInput.getNodeId());
            messageInput.setPersistId(inputId);
            Input mongoInput = this.getInput(messageInput);
            List<Extractor> extractors = this.inputService.getExtractors(oldInput);
            Map<String, String> staticFields = oldInput.getStaticFields();
            this.inputService.save(mongoInput);
            for (Map.Entry<String, String> entry : staticFields.entrySet()) {
                this.inputService.addStaticField(mongoInput, entry.getKey(), entry.getValue());
            }
            for (Extractor extractor : extractors) {
                this.inputService.addExtractor(mongoInput, extractor);
            }
        }
        catch (NoSuchInputTypeException e) {
            e.printStackTrace();
        }
        URI inputUri = UriBuilder.fromResource(InputsResource.class).path("{inputId}").build(new Object[]{inputId});
        return Response.created((URI)inputUri).entity((Object)InputCreated.create(inputId)).build();
    }

    @POST
    @Timed
    @Path(value="/{inputId}/launch")
    @ApiOperation(value="Launch existing input on this node")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public void launchExisting(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        MessageInput messageInput;
        IOState inputState = this.inputRegistry.getInputState(inputId);
        if (inputState == null) {
            try {
                Input input = this.inputService.findForThisNodeOrGlobal(this.serverStatus.getNodeId().toString(), inputId);
                messageInput = this.inputService.getMessageInput(input);
                messageInput.initialize();
            }
            catch (org.graylog2.database.NotFoundException | NoSuchInputTypeException e) {
                String error = "Cannot launch input <" + inputId + ">. Input not found.";
                LOG.info(error);
                throw new NotFoundException(error);
            }
        } else {
            messageInput = (MessageInput)inputState.getStoppable();
        }
        if (messageInput == null) {
            String error = "Cannot launch input <" + inputId + ">. Input not found.";
            LOG.info(error);
            throw new NotFoundException(error);
        }
        this.inputLauncher.launch(messageInput);
    }

    @POST
    @Timed
    @Path(value="/{inputId}/stop")
    @ApiOperation(value="Stop existing input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public InputStateSummary stop(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        MessageInput input = this.inputRegistry.getRunningInput(inputId);
        if (input == null) {
            LOG.info("Cannot stop input. Input not found.");
            throw new NotFoundException();
        }
        IOState inputState = this.inputRegistry.stop(input);
        return this.getInputStateSummary((IOState<MessageInput>)inputState);
    }

    @POST
    @Timed
    @Path(value="/{inputId}/restart")
    @ApiOperation(value="Restart existing input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    public Response restart(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        IOState oldState = this.inputRegistry.getRunningInputState(inputId);
        this.stop(inputId);
        this.inputRegistry.remove(oldState);
        this.launchExisting(inputId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }
}

