/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.logs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.log4j.Level;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Loggers", description="Internal Graylog loggers")
@Path(value="/system/loggers")
public class LoggersResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(LoggersResource.class);
    private static final Map<String, Subsystem> SUBSYSTEMS = ImmutableMap.of((Object)"graylog2", (Object)new Subsystem("Graylog2", "org.graylog2", "All messages from graylog2-owned systems."), (Object)"indexer", (Object)new Subsystem("Indexer", "org.elasticsearch", "All messages related to indexing and searching."), (Object)"authentication", (Object)new Subsystem("Authentication", "org.apache.shiro", "All user authentication messages."), (Object)"sockets", (Object)new Subsystem("Sockets", "netty", "All messages related to socket communication."));

    @GET
    @Timed
    @ApiOperation(value="List all loggers and their current levels")
    @Produces(value={"application/json"})
    public Map<String, Object> loggers() {
        HashMap loggerList = Maps.newHashMap();
        Enumeration loggers = org.apache.log4j.Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)loggers.nextElement();
            if (!this.isPermitted("loggers:read", logger.getName())) continue;
            HashMap loggerInfo = Maps.newHashMap();
            loggerInfo.put("level", logger.getEffectiveLevel().toString().toLowerCase());
            loggerInfo.put("level_syslog", logger.getEffectiveLevel().getSyslogEquivalent());
            loggerList.put(logger.getName(), loggerInfo);
        }
        return ImmutableMap.of((Object)"loggers", (Object)loggerList, (Object)"total", (Object)loggerList.size());
    }

    @GET
    @Timed
    @Path(value="/subsystems")
    @ApiOperation(value="List all logger subsystems and their current levels")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Object>> subsytems() {
        HashMap subsystems = Maps.newHashMap();
        for (Map.Entry<String, Subsystem> subsystem : SUBSYSTEMS.entrySet()) {
            if (!this.isPermitted("loggers:readsubsystem", subsystem.getKey())) continue;
            try {
                HashMap info = Maps.newHashMap();
                info.put("title", subsystem.getValue().getTitle());
                info.put("category", subsystem.getValue().getCategory());
                info.put("description", subsystem.getValue().getDescription());
                Level effectiveLevel = org.apache.log4j.Logger.getLogger((String)subsystem.getValue().getCategory()).getEffectiveLevel();
                info.put("level", effectiveLevel.toString().toLowerCase());
                info.put("level_syslog", effectiveLevel.getSyslogEquivalent());
                subsystems.put(subsystem.getKey(), info);
            }
            catch (Exception e) {
                LOG.warn("Error while listing logger subsystem.", (Throwable)e);
            }
        }
        return ImmutableMap.of((Object)"subsystems", (Object)subsystems);
    }

    @PUT
    @Timed
    @ApiOperation(value="Set the loglevel of a whole subsystem", notes="Provided level is falling back to DEBUG if it does not exist")
    @ApiResponses(value={@ApiResponse(code=404, message="No such subsystem.")})
    @Path(value="/subsystems/{subsystem}/level/{level}")
    public void setSubsystemLoggerLevel(@ApiParam(name="subsystem", required=true) @PathParam(value="subsystem") String subsystemTitle, @ApiParam(name="level", required=true) @PathParam(value="level") String level) {
        if (!SUBSYSTEMS.containsKey(subsystemTitle)) {
            LOG.warn("No such subsystem: [{}]. Returning 404.", (Object)subsystemTitle);
            throw new NotFoundException();
        }
        this.checkPermission("loggers:editsubsystem", subsystemTitle);
        Subsystem subsystem = SUBSYSTEMS.get(subsystemTitle);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)subsystem.getCategory());
        Level newLevel = Level.toLevel((String)level.toUpperCase());
        logger.setLevel(newLevel);
    }

    @PUT
    @Timed
    @ApiOperation(value="Set the loglevel of a single logger", notes="Provided level is falling back to DEBUG if it does not exist")
    @Path(value="/{loggerName}/level/{level}")
    public void setSingleLoggerLevel(@ApiParam(name="loggerName", required=true) @PathParam(value="loggerName") String loggerName, @ApiParam(name="level", required=true) @PathParam(value="level") String level) {
        this.checkPermission("loggers:edit", loggerName);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)loggerName);
        Level newLevel = Level.toLevel((String)level.toUpperCase());
        logger.setLevel(newLevel);
    }

    private static class Subsystem {
        private final String title;
        private final String category;
        private final String description;

        public Subsystem(String title, String category, String description) {
            this.title = title;
            this.category = category;
            this.description = description;
        }

        private String getTitle() {
            return this.title;
        }

        private String getCategory() {
            return this.category;
        }

        private String getDescription() {
            return this.description;
        }
    }
}

