/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.buffers;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.buffers.processors.OutputBufferProcessor;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.buffers.MessageEvent;
import org.graylog2.shared.buffers.LoggingExceptionHandler;
import org.graylog2.shared.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OutputBuffer
extends Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(OutputBuffer.class);
    private final Meter incomingMessages;

    @Inject
    public OutputBuffer(MetricRegistry metricRegistry, Provider<OutputBufferProcessor> processorProvider, @Named(value="outputbuffer_processors") int processorCount, @Named(value="ring_size") int ringSize, @Named(value="processor_wait_strategy") String waitStrategyName) {
        ExecutorService executor = this.executorService(metricRegistry);
        this.ringBufferSize = ringSize;
        this.incomingMessages = metricRegistry.meter(MetricRegistry.name(OutputBuffer.class, (String[])new String[]{"incomingMessages"}));
        MetricUtils.safelyRegister((MetricRegistry)metricRegistry, (String)"org.graylog2.buffers.output.usage", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return OutputBuffer.this.getUsage();
            }
        });
        MetricUtils.safelyRegister((MetricRegistry)metricRegistry, (String)"org.graylog2.buffers.output.size", (Metric)MetricUtils.constantGauge((long)this.ringBufferSize));
        WaitStrategy waitStrategy = this.getWaitStrategy(waitStrategyName, "processor_wait_strategy");
        Disruptor disruptor = new Disruptor(MessageEvent.EVENT_FACTORY, this.ringBufferSize, (Executor)executor, ProducerType.MULTI, waitStrategy);
        disruptor.handleExceptionsWith((ExceptionHandler)new LoggingExceptionHandler(LOG));
        LOG.info("Initialized OutputBuffer with ring size <{}> and wait strategy <{}>.", (Object)this.ringBufferSize, (Object)waitStrategy.getClass().getSimpleName());
        WorkHandler[] processors = new OutputBufferProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            processors[i] = (OutputBufferProcessor)processorProvider.get();
        }
        disruptor.handleEventsWithWorkerPool(processors);
        this.ringBuffer = disruptor.start();
    }

    private ExecutorService executorService(MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("outputbufferprocessor-%d").build();
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), metricRegistry, MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"executor-service"}));
    }

    public void insertBlocking(Message message) {
        this.insert(message);
    }

    protected void afterInsert(int n) {
        this.incomingMessages.mark((long)n);
    }
}

